/*
 * linux/include/asm-arm/arch-omap/pa.h
 *
 * Copyright (C) 2007 Nokia Corporation
 * Author: Sami Tolvanen <sami.tolvanen@nokia.com>
 *
 * OMAP HS protected applications (PA) format handling
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

typedef struct {
	u32 type;
	u32 size;
	u32 ref;
	u32 value;
} pa_format_entry;

typedef struct {
	u32 cmd;
	u8 filename[12];	/* TOC filename */
	u8 sa;			/* Sub-application */
	u8 index;		/* Function index */
	u8 npar;
	u8 nres;
} pa_format_command;

typedef struct {
	u32 magic;
	u32 ncmd;
} pa_format_header;

typedef struct {
	pa_format_command *cmd;
	pa_format_entry **par;
	pa_format_entry **res;
} pa_command;

typedef struct {
	pa_command *cmd;	/* Commands */
	u32 ncmd;
} pa_format;

typedef void * (*pa_ptr_conv)(const void *);

typedef struct {
	pa_command *c;
	pa_format *format;
	pa_ptr_conv ptv;	/* Physical -> virtual */
	pa_ptr_conv vtp;	/* Virtual -> physical */
	u32 cinp;
	u32 coup;
	u32 cpar;		/* PA parameter buffer size */
	u32 cres;		/* PA result buffer size */
	u8 *input;
	u8 *output;
	u8 *par;
	u8 *res;
	void *keys;		/* Public keys (KEYS) */
	void *papub;		/* PA public keys (PAPUBKEYS) */
} pa_command_data;

extern int pa_image_address_get(u8 *base, u8 *name, void **addr);

extern void pa_format_free(pa_format *p);

extern int pa_format_parse(u8 *base, u32 size, pa_format *p);

extern int pa_command_query(u32 cmd, u8 *input, u32 cinp, u32 *mininp,
		u32 *maxout, pa_format *p);

extern int pa_command_prepare(u32 cmd, pa_command_data *p);

extern int pa_command_finish(pa_command_data *p);
