/*
 * linux/include/asm-arm/arch-omap/observability.h
 *
 * Interface for using debug functionalities on OMAP24XX
 *
 * Copyright (C) 2006 Nokia Corporation
 * Igor Stoppa <igor.stoppa@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef OMAP_OBSERVABILITY_H
#define OMAP_OBSERVABILITY_H

enum dbg_gpios {
	OMAP2420_HW_DBG_GPIO49 = 0,
	OMAP2420_HW_DBG_GPIO50,
	OMAP2420_HW_DBG_GPIO51,
	OMAP2420_HW_DBG_GPIO52,
	OMAP2420_HW_DBG_GPIO53,
	OMAP2420_HW_DBG_GPIO54,
	OMAP2420_HW_DBG_GPIO55,
	OMAP2420_HW_DBG_GPIO56,
	OMAP2420_HW_DBG_GPIOS_NUM
};

enum omap_dbg_modes {
	OMAP2420_HW_DBG_MODE_CAMERA = 0,
	OMAP2420_HW_DBG_MODE_OBS,
	OMAP2420_HW_DBG_MODE_GPIO,
	OMAP2420_HW_DBG_MODE_PEEK,
	OMAP2420_HW_DBG_MODES_NUM
};

enum omap_dbg_register_sizes {
	OMAP2420_HW_DBG_REG_SIZE_1,
	OMAP2420_HW_DBG_REG_SIZE_2,
	OMAP2420_HW_DBG_REG_SIZE_4,
	OMAP2420_HW_DBG_REG_SIZES_NUM
};

int omap_set_dbg_gpio_val(enum dbg_gpios gpio, u8 val);
int omap_get_dbg_gpio_word(void);
int omap_set_dbg_gpio_word(u8 val);
void omap_set_dbg_mode(const enum omap_dbg_modes mode);
inline void omap_dbg_set_register_size(const enum omap_dbg_register_sizes new_size);
inline enum omap_dbg_register_sizes omap_dbg_get_register_size(void);
inline void omap_dbg_set_address(unsigned * new_address);
inline unsigned * omap_dbg_get_address(void);
inline void omap_dbg_set_position(unsigned new_position);
inline unsigned omap_dbg_get_position(void);
inline void omap_dbg_set_visible_byte(u8 new_visible_byte);
inline u8 omap_dbg_get_visible_byte(void);
inline void omap_dbg_update_visible_byte(void);

#endif
