/*
 * pc2400m_if_netlink.h
 *
 *
 * Copyright (C) 2007 Nokia Corporation
 * Author: Jouni Lappi <jouni.lappi@nokia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */


#ifndef PC2400M_NETLINK_H
#define PC2400M_NETLINK_H

#define NETLINK_PC2400M1		17	
#define NETLINK_PC2400M2		18	
#define NETLINK_PC2400M3		19

#define NETLINK_PIPE_TYPE_TRACE   0x01
#define NETLINK_PIPE_TYPE_MESSAGE 0x02

#define NETLINK_TRACE_TYPE_EMPTY  0x00
#define NETLINK_TRACE_TYPE_BYTE   0x01
#define NETLINK_TRACE_TYPE_U16    0x02
#define NETLINK_TRACE_TYPE_U32    0x03
#define NETLINK_TRACE_TYPE_STR    0x04
#define NETLINK_TRACE_TYPE_HEX    0x05

#define NETLINK_PIPE_VERSION      0x00000001

struct netlink_pipe_msg_str {
	u32 type;
	u32 length;
	u32 version;
};

struct netlink_trace_msg_str {
	struct netlink_pipe_msg_str header;
	u32 trace_type;
	u32 trace_group;
	u32 trace_id;
	u32 trace_len;
};


void pc2400m_netlink_init(struct net_device *ndev);
int  pc2400m_netlink_trace_pipe_ready(struct net_device *ndev);
int  pc2400m_netlink_send_data(struct net_device *ndev,
			       struct sk_buff *skb, 
			       char netlink);
void pc2400m_netlink_close(void);

#endif /* PC2400M_NETLINK_H */
