/*
 * pc2400m_drv_ring.h
 *
 * Copyright (C) 2007 Nokia Corporation
 * Author: Juuso Oikarinen <juuso.oikarinen@nokia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */


#ifndef PC2400M_DRV_RING_H
#define PC2400M_DRV_RING_H


#define Q_EMPTY(q)   (q##_e == q##_s)
#define Q_FULL(q,s)  (q##_e == q##_s-1 || (q##_s == 0 && \
                      q##_e == s-1))
#define Q_PUT(q,s)   (q##_e=(++q##_e)%s)
#define Q_GET(q,s)   (q##_s=(++q##_s)%s)
#define Q_LEN(q,s)   (q##_s<=q##_e?q##_e-q##_s:s+q##_e-q##_s)

#define Q_DECLARE(q, type, size) \
        u32 q##_s; \
        u32 q##_e; \
	type q[size];

#endif /* PC2400M_DRV_RING_H */
