/*
 * pc2400m_drv_hdi.h
 *
 * Copyright (C) 2007 Nokia Corporation
 * Author: Juuso Oikarinen <juuso.oikarinen@nokia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */


#ifndef PC2400M_DRV_HDI_H
#define PC2400M_DRV_HDI_H

#include "pc2400m_osal.h"
#include "pc2400m_al.h"

struct pc2400m_drv_hdi_if;

typedef spi_irq_cb pc2400m_hdi_int_cb;
typedef wimax_osal_packet* (*pc2400m_hdi_put_fnc)(struct pc2400m_drv_hdi_if*,
						  wimax_osal_packet*,s32);
typedef wimax_osal_packet* (*pc2400m_hdi_get_fnc)(
	struct pc2400m_drv_hdi_if*, s32*);
typedef s32 (*pc2400m_hdi_write_fnc)(struct pc2400m_drv_hdi_if*);
typedef s32 (*pc2400m_hdi_read_fnc)(struct pc2400m_drv_hdi_if*);
typedef s32 (*pc2400m_hdi_init_fnc)(struct pc2400m_drv_hdi_if*, 
				  u8*, 
				  u32, 
				  pc2400m_hdi_int_cb);
typedef void (*pc2400m_hdi_cleanup_fnc)(struct pc2400m_drv_hdi_if*);
typedef void (*pc2400m_hdi_reset_fnc)(struct pc2400m_drv_hdi_if*);

struct pc2400m_drv_hdi_if {
	pc2400m_hdi_put_fnc put;
	pc2400m_hdi_get_fnc get;
	pc2400m_hdi_write_fnc write;
	pc2400m_hdi_read_fnc read;
	pc2400m_hdi_init_fnc initialize;
	pc2400m_hdi_reset_fnc reset;
	pc2400m_hdi_cleanup_fnc cleanup;

	wimax_osal_context *ctx;

};

/* instantiator function */
struct pc2400m_drv_hdi_if *pc2400m_drv_hdi_if_new(wimax_osal_context* ctx);


#endif /* PC2400M_DRV_HDI_H */
