/*
 * pc2400m_drv_cd.h
 *
 * Copyright (C) 2007 Nokia Corporation
 * Author: Juuso Oikarinen <juuso.oikarinen@nokia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */



#ifndef PC2400M_DRV_CD_H
#define PC2400M_DRV_CD_H

#include "pc2400m_osal.h"

struct pc2400m_drv_cd_if;
struct pc2400m_drv_hdi_if;

typedef void (*cd_msg_enqueue_cb)(struct pc2400m_drv_cd_if*, 
				  wimax_osal_packet*, 
				  void*);
typedef s32 (*cd_msg_enqueue_func)(struct pc2400m_drv_cd_if*, 
				   wimax_osal_packet*, 
				   cd_msg_enqueue_cb, 
				   void*, 
				   u32);
typedef s32 (*cd_msg_remove_func)(struct pc2400m_drv_cd_if*, s32);
typedef void (*cd_reset_func)(struct pc2400m_drv_cd_if*);
typedef void (*cd_cleanup_func)(struct pc2400m_drv_cd_if*);
typedef void (*cd_indication_cb)(struct pc2400m_drv_cd_if*, 
				 u32, 
				 wimax_osal_packet*, 
				 void*);
typedef s32 (*cd_register_indication_func)(struct pc2400m_drv_cd_if*, 
					   u32, 
					   cd_indication_cb, 
					   void*);
typedef s32 (*cd_pkt_enqueue_func)(struct pc2400m_drv_cd_if*, 
				   wimax_osal_packet*, s32, u32);
typedef s32 (*cd_initialize_func)(struct pc2400m_drv_cd_if*,
				  struct pc2400m_drv_hdi_if*);
typedef void (*cd_pkt_handler_cb)(struct pc2400m_drv_cd_if*, 
				  wimax_osal_packet*, 
				  s32,
				  void*);
typedef s32 (*cd_register_pkt_handler_func)(struct pc2400m_drv_cd_if*, 
					 cd_pkt_handler_cb, void*);
typedef void (*cd_dbg_handler_cb)(struct pc2400m_drv_cd_if*, 
				  wimax_osal_packet*, 
				  void*);
typedef s32 (*cd_register_dbg_handler_func)(struct pc2400m_drv_cd_if*, 
					    cd_dbg_handler_cb, void*);
typedef void (*cd_prod_handler_cb)(struct pc2400m_drv_cd_if*, 
				   wimax_osal_packet*, 
				   void*);
typedef s32 (*cd_register_prod_handler_func)(struct pc2400m_drv_cd_if*, 
					     cd_prod_handler_cb, void*);
typedef void (*cd_interrupt_func)(struct pc2400m_drv_cd_if*);
typedef void (*cd_suspend_cb)(struct pc2400m_drv_cd_if*, void*);
typedef s32 (*cd_suspend_func)(struct pc2400m_drv_cd_if*, 
			       cd_suspend_cb, 
			       void*);
typedef s32 (*cd_resume_func)(struct pc2400m_drv_cd_if*);


/* flags for packet and data enqueueing */
#define PC2400M_CD_FLAG_NONE      0x00000000
#define PC2400M_CD_FLAG_AGGREGATE 0x00000001
#define PC2400M_CD_FLAG_URGENT    0x00000002

/* structure representing the control dispatcher */
struct sllist;
struct cd_ctrl_msg_elem;
struct pc2400m_drv_cd_if {
	wimax_osal_context *ctx;
	cd_msg_enqueue_func msg_enqueue;
	cd_msg_remove_func msg_remove;
	cd_cleanup_func cleanup;
	cd_reset_func reset;
	cd_register_indication_func register_indication;
	cd_pkt_enqueue_func pkt_enqueue;
	cd_initialize_func initialize;
	cd_register_pkt_handler_func register_pkt_handler;
	cd_register_dbg_handler_func register_dbg_handler;
	cd_register_prod_handler_func register_prod_handler;
	cd_interrupt_func interrupt;
	cd_suspend_func suspend;
	cd_resume_func resume;

	/* instance variables */
	struct pc2400m_drv_hdi_if *hdi;
	struct sllist *ind_list;
	struct sllist *ctrl_list;
	wimax_osal_packet_list pkt_list;
	struct cd_ctrl_msg_elem *ctrl_processed;

	/* state flags */
#define PC2400_DRV_CD_FLAGS_SUSPENDED 0x00000001
	u32 flags;

	/* data handlers */
	cd_pkt_handler_cb pkt_handler;
	void *pkt_handler_data;

	cd_dbg_handler_cb dbg_handler;
	void *dbg_handler_data;

	cd_prod_handler_cb prod_handler;
	void *prod_handler_data;

	cd_suspend_cb suspend_cb;
	void *suspend_cb_data;

};

/* cd instantiator function */
struct pc2400m_drv_cd_if *pc2400m_drv_cd_if_new(wimax_osal_context* ctx);


#endif /* PC2400M_DRV_CD_H */
