/*
 * pc2400m_al.h
 *
 * Copyright (C) 2007 Nokia Corporation
 * Author: Juuso Oikarinen <juuso.oikarinen@nokia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */


#ifndef PC2400M_AL_H
#define PC2400M_AL_H

#include "pc2400m_spi.h"
#include "pc2400m_osal.h"
#include "pc2400m_drv_if.h"

/* SPI configuration flags */
#define SPI_CONFIG_SAMPLE_FALLING     0x00000001

typedef void (*spi_commit_cb)(wimax_osal_context*, s32, void*);
typedef void (*spi_irq_cb)(wimax_osal_context*);
typedef s32 (*spi_h2d_fnc)(wimax_osal_context*, u8* , s32);
typedef s32 (*spi_d2h_fnc)(wimax_osal_context*, u8*, s32);
typedef s32 (*spi_commit_fnc)(wimax_osal_context*, spi_commit_cb, void*);
typedef void (*spi_enable_irq_fnc)(wimax_osal_context*, spi_irq_cb);
typedef void (*spi_configure_fnc)(wimax_osal_context*, u32, u32);
typedef void (*spi_set_power_fnc)(wimax_osal_context*, u8);


/* SPI and network interface abstraction */
struct adaptation_if {

	/* SPI adaptation */
	spi_h2d_fnc               h2d;
	spi_d2h_fnc               d2h;
	spi_commit_fnc            commit;
	spi_enable_irq_fnc        enable_irq;
	spi_configure_fnc         configure;
	spi_set_power_fnc         set_power;

	/* Network interface */
	drv_cmd_response_fnc      cmd_resp;
	drv_indication_fnc        ind;

};

/* make the adaptation visible to the library. NOTE: this causes a symbol
   name dependency between the driver library and the client. */
extern struct adaptation_if pc2400m_drv_adapt;

#ifndef CONFIG_NET_PC2400M_SIM
#define PC2400M_DRV_SPI_TEST
#endif 

#endif /* PC2400M_AL_H */
