/*
 * arch/arm/mach-omap2/dvfs.h
 *
 * Copyright (C) 2007 Nokia Corporation.
 *
 * Contact: Igor Stoppa <igor.stoppa@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __DVFS_H
#define __DVFS_H

#define SYNC_DISABLED	0
#define SYNC_ENABLED	1

#define SYS_CLK		0

enum omap242x_op_parms {
	MPU_CLK_KHZ = 0,
	DSP_CLK_KHZ,
	GFX_CLK_KHZ,
	IVA_CLK_KHZ,
	L3_CLK_KHZ,
	L4_CLK_KHZ,
	_54M_SRC_CLK_KHZ,
	_48M_SRC_CLK_KHZ,
	DPLL_CLK_KHZ,
	CORE_CLK_KHZ,
	DSP_IF_CLK_KHZ,
	DSP_SYNC,
	IVA_SYNC,
	DSS1_CLK_KHZ,
	DSS2_CLK_KHZ,
	VLYNQ_CLK_KHZ,
	SSI_CLK_KHZ,
	USB_CLK_KHZ,
	VCORE_ROOF_MV,
	NUM_OP_PARMS,
};

/* Note: the members of omap242x_op_parms that are used in freq_tables
   _must_ be grouped at the beginning of the enum.*/
enum freq_tables {
	MPU_TABLE = MPU_CLK_KHZ,
	DSP_TABLE = DSP_CLK_KHZ,
	GFX_TABLE = GFX_CLK_KHZ,
	IVA_TABLE = IVA_CLK_KHZ,
	L3_TABLE = L3_CLK_KHZ,
	L4_TABLE = L4_CLK_KHZ,
	NUM_TABLES,
};

struct omap242x_freq_tables *omap242x_get_freq_tableset(void);
int omap242x_load_op_list(const unsigned int list[][NUM_OP_PARMS],
			  unsigned int num, unsigned int active);
int omap242x_dvfs_set_op(const unsigned int target);
unsigned int omap242x_dvfs_get_op(void);

#ifdef CONFIG_MACH_OMAP2420_DVFS
int dvfs_init(void) __init;
#else
static inline int __init dvfs_init(void) { return 0; }
#endif

#endif
