/*
 * This file is part of libgst0.10-dsp
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Stefan Kost <stefan.kost@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef __GST_DSPPCMSINK_H__
#define __GST_DSPPCMSINK_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gst/gst.h>
#include <gst/base/gstbasesink.h>

#include <dspaudio.h>

G_BEGIN_DECLS

#define GST_TYPE_DSPPCMSINK            (gst_dsppcmsink_get_type())
#define GST_DSPPCMSINK(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_DSPPCMSINK,GstDSPPCMSink))
#define GST_DSPPCMSINK_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_DSPPCMSINK,GstDSPPCMSinkClass))
#define GST_IS_DSPPCMSINK(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_DSPPCMSINK))
#define GST_IS_DSPPCMSINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_DSPPCMSINK))

typedef struct _GstDSPPCMSink GstDSPPCMSink;
typedef struct _GstDSPPCMSinkClass GstDSPPCMSinkClass;

struct _GstDSPPCMSink {
  GstBaseSink   sink;
  GstDSPAudio   *audio;
  GstClock      *provided_clock;

  // audio stream info
  gint           width;
  gint           depth;
  gint           channels_fmt;
  gint           rate_fmt;
  gint           endianness;
  guint          bps;
  guint          format;
  gboolean       sign;

  // "Raw values"
  gint           rate;
  gint           channels;

  guint          outIndex;
  guint          buf_limit;
};

struct _GstDSPPCMSinkClass {
  GstBaseSinkClass parent_class;
};


GType gst_dsppcmsink_get_type(void);

G_END_DECLS

#endif /* __GST_DSPPCMSINK_H__ */
