/*
 * This file is part of libgst0.10-dsp
 *
 * Copyright (C) 2007 Nokia Corporation. All rights reserved.
 *
 * Contact: Stefan Kost <stefan.kost@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef __GST_DSPG711SINK_H__
#define __GST_DSPG711SINK_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gst/gst.h>
#include <gst/base/gstbasesink.h>

#include <dspaudio.h>

G_BEGIN_DECLS


#define GST_TYPE_DSPG711SINK            (gst_dspg711sink_get_type())
#define GST_DSPG711SINK(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_DSPG711SINK,GstDSPG711Sink))
#define GST_DSPG711SINK_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_DSPG711SINK,GstDSPG711SinkClass))
#define GST_IS_DSPG711SINK(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_DSPG711SINK))
#define GST_IS_DSPG711SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_DSPG711SINK))


typedef struct _GstDSPG711Sink GstDSPG711Sink;
typedef struct _GstDSPG711SinkClass GstDSPG711SinkClass;

struct _GstDSPG711Sink {
  GstBaseSink     sink;
  GstDSPAudio     *audio;
};

struct _GstDSPG711SinkClass {
  GstBaseSinkClass parent_class;
};

GType gst_dspg711sink_get_type(void);

gboolean gst_dspg711sink_factory_init (GstElementFactory *factory);

G_END_DECLS

#endif /* __GST_DSPG711SINK_H__ */
