/*
 * This file is part of eds-sync
 *
 * Copyright (C) 2007 Nokia Corporation. All rights reserved.
 *
 * Author: Ross Burton <ross@openedhand.com>
 * Author: Onne Gorter <onne.gorter@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __NOTIFICATION_RTCOM_H__
#define __NOTIFICATION_RTCOM_H__

#include <glib-object.h>
#include <osso-contact-plugin/rtcom-cp-interface.h>

G_BEGIN_DECLS

#define EDS_TYPE_NOTIFY_CONTEXT_RTCOM           (eds_notify_context_rtcom_get_type ())
#define EDS_NOTIFY_CONTEXT_RTCOM(obj)           (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDS_TYPE_NOTIFY_CONTEXT_RTCOM, EdsNotifyContextRtcom))
#define EDS_IS_NOTIFY_CONTEXT_RTCOM(obj)        (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDS_TYPE_NOTIFY_CONTEXT_RTCOM))

typedef struct _EdsNotifyContextRtcom           EdsNotifyContextRtcom;
typedef struct _EdsNotifyContextRtcomClass      EdsNotifyContextRtcomClass;

struct _EdsNotifyContextRtcom
{
  GObject parent_instance;

  RtcomCPInterface *rtcom;
  GHashTable *op_hash;
};

struct _EdsNotifyContextRtcomClass
{
  GObjectClass parent_instance;
};

GType eds_notify_context_rtcom_get_type (void) G_GNUC_CONST;

G_END_DECLS

#endif /* __NOTIFICATION_RTCOM_H__ */
