/*
 * UPnP Browser for Maemo
 *
 * settings.h
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license,
 * see file COPYING.
 */

#ifndef SETTINGS_H
#define SETTINGS_H

#include <gtk/gtk.h>
#include <gconf/gconf-client.h>

#define _(String) gettext(String)

typedef struct _UPnPBrowserSettings
{
	gint transportUpdateInterval;
	gboolean updateServers;
	gboolean resolveTitles;
	gboolean sendMetaData;
	
} UPnPBrowserSettings;

gboolean settings_load(UPnPBrowserSettings* settings);
gboolean settings_save(UPnPBrowserSettings* settings);

gboolean settings_edit_dialog(UPnPBrowserSettings* settings);
GtkWidget* create_settings_dialog(UPnPBrowserSettings* cache);

/****************************************************************************
 * Callbacks
 ****************************************************************************/
void transport_update_interval_changed(GtkSpinButton *spinbutton,
				       gpointer user_data);

void update_servers_toggled(GtkToggleButton *togglebutton,
			   gpointer user_data);

void resolve_titles_toggled(GtkToggleButton *togglebutton,
			   gpointer user_data);

void send_meta_data_toggled(GtkToggleButton *togglebutton,
			    gpointer user_data);

#endif
