/*
 * UPnP Browser for Maemo (player part)
 *
 * player.h
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license,
 * see file COPYING.
 */

#ifndef _PLAYER_H_
#define _PLAYER_H_

#include <glib.h>
#include <libosso.h>

/**
 * PLAYER_VOLUME_MODIFIER:
 *
 * Modification value for modding the value into format engine or volumebar
 * understands.
 **/
#define PLAYER_VOLUME_MODIFIER 100.0

/**
 * PLAYER_DBUS_ENGINE_INTERFACE_NAME:
 *
 * DBUS interface name for the media player engine. The music player
 * interface object name.
 **/
#define PLAYER_DBUS_ENGINE_INTERFACE_NAME "com.nokia.osso_media_server.music"

/**
 * PLAYER_DBUS_ENGINE_OBJECT_NAME:
 *
 * DBUS interface object path for media player engine.
 **/
#define PLAYER_DBUS_ENGINE_OBJECT_NAME "/com/nokia/osso_media_server"

/**
 * PLAYER_DBUS_ENGINE_SERVICE_NAME:
 *
 * DBUS interface name for media player engine.
 **/
#define PLAYER_DBUS_ENGINE_SERVICE_NAME "com.nokia.osso_media_server"

/**
 * PLAYER_DBUS_ENGINE_INTERFACE_ERROR_NAME:
 *
 * DBUS interface name for media player engine.
 **/
#define PLAYER_DBUS_ENGINE_INTERFACE_ERROR_NAME "com.nokia.osso_media_server"\
                                                ".music.error"

/**
 * PLAYER_DBUS_MUSIC_PLAYER_ERROR:
 *
 * Error type sent to a calling client when something could not be
 * done in DBUS functions.
 **/
#define PLAYER_DBUS_MUSIC_PLAYER_ERROR "com.nokia.osso_music_player.error"

#define PLAYER_PLAY_TIMEOUT 10

gboolean player_play_uri(osso_context_t *osso, const gchar *uri, GError **err);

gboolean player_stop(osso_context_t *osso, GError **err);

gboolean player_pause(osso_context_t *osso, GError **err);

gboolean player_set_mute(osso_context_t *osso, gboolean muted, GError **err);

gboolean player_set_volume(osso_context_t *osso, gint value, GError **err);

gboolean player_get_position(osso_context_t *osso, gint *pos, gint *length, GError **err);

#endif /* _PLAYER_H_ */
