/* 
 * CyberLinkC AV API for Control Points
 *
 * cavtactionarguments.h
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license,
 * see file COPYING.
 */

#ifndef CG_UPNP_AV_CAVTACTIONARGUMENTS_H
#define CG_UPNP_AV_CAVTACTIONARGUMENTS_H

/* Generic AV Transport ID */
#define CG_UPNP_AVT_ARG_INSTANCEID "InstanceID"

/* Arguments for SetAVTransportURI, SetNextAVTransportURI and GetMediaInfo */
#define CG_UPNP_AVT_ARG_NRTRACKS "NrTracks"
#define CG_UPNP_AVT_ARG_MEDIADURATION "MediaDuration"
#define CG_UPNP_AVT_ARG_CURRENTURI "CurrentURI"
#define CG_UPNP_AVT_ARG_CURRENTURIMETADATA "CurrentURIMetaData"
#define CG_UPNP_AVT_ARG_NEXTURI "NextURI"
#define CG_UPNP_AVT_ARG_NEXTURIMETADATA "NextURIMetaData"
#define CG_UPNP_AVT_ARG_PLAYMEDIUM "PlayMedium"
#define CG_UPNP_AVT_ARG_RECORDMEDIUM "RecordMedium"
#define CG_UPNP_AVT_ARG_WRITESTATUS "WriteStatus"

/* Arguments for GetTransportInfo */
#define CG_UPNP_AVT_ARG_CURRENTTRANSPORTSTATE "CurrentTransportState"
#define CG_UPNP_AVT_ARG_CURRENTTRANSPORTSTATUS "CurrentTransportStatus"
#define CG_UPNP_AVT_ARG_CURRENTSPEED "CurrentSpeed"

/* Arguments for GetPositionInfo */
#define CG_UPNP_AVT_ARG_TRACK "Track"
#define CG_UPNP_AVT_ARG_TRACKDURATION "TrackDuration"
#define CG_UPNP_AVT_ARG_TRACKMETADATA "TrackMetaData"
#define CG_UPNP_AVT_ARG_TRACKURI "TrackURI"
#define CG_UPNP_AVT_ARG_RELTIME "RelTime"
#define CG_UPNP_AVT_ARG_ABSTIME "AbsTime"
#define CG_UPNP_AVT_ARG_RELCOUNT "RelCount"
#define CG_UPNP_AVT_ARG_ABSCOUNT "AbsCount"

/* Arguments for GetDeviceCapabilities */
#define CG_UPNP_AVT_ARG_PLAYMEDIA "PlayMedia"
#define CG_UPNP_AVT_ARG_RECMEDIA "RecMedia"
#define CG_UPNP_AVT_ARG_RECQUALITYMODES "RecQualityModes"

/* Arguments for GetTransportSettings */
#define CG_UPNP_AVT_ARG_PLAYMODE "PlayMode"
#define CG_UPNP_AVT_ARG_RECQUALITYMODE "RecQualityMode"

/* Arguments for Play */
#define CG_UPNP_AVT_ARG_SPEED "Speed"

/* Arguments for Seek */
#define CG_UPNP_AVT_ARG_UNIT "Unit"
#define CG_UPNP_AVT_ARG_TARGET "Target"

/* Arguments for SetPlayMode */
#define CG_UPNP_AVT_ARG_NEWPLAYMODE "NewPlayMode"

/* Arguments for SetRecordQualityMode */
#define CG_UPNP_AVT_ARG_NEWRECORDQUALITYMODE "NewRecordQualityMode"

/* Arguments for GetCurrentTransportActions */
#define CG_UPNP_AVT_ARG_ACTIONS "Actions"

#endif
