/* Certificate Management library
 * 
 * Copyright (C) 2005 Nokia. All rights reserved.
 * Author: Ed Bartosh <Eduard.Bartosh@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/** test.h **/
#ifndef TEST_H_
#define TEST_H_

#include "cst.h"

#ifdef __cplusplus
extern "C" {
#endif

/* MUST BE LONG */
#define PASSWORD "pas"
#define DB "certman.cst"
#define DB_CRASHED "crashed.cst" 
#define DEF_PASS "234345236"

/* Helper struct for tests */
    typedef struct PARAM_st {
        int counter_ok;
        int counter_err;

        CST *st;
        CST *st_two;
        X509 *ca;
        guint ca_uid;
        X509_NAME *name;
        
        X509 *cert;
        guint cert_uid;
        
        X509 *user_cert;
        X509_NAME *user_name;
        guint user_cert_uid;

        X509 *hotbox_cert;
        X509 *jboss_cert;

        EVP_PKEY * private_key;
        EVP_PKEY * public_key;
        EVP_PKEY * user_private_key;
    } PARAM;

/* Helper macros */

#define TEST_CHECK(b, msg) if(b) printOk(msg); else printErr(msg);

#define TEST_TITLE(title) printf("==== %s ====\n", title)

#define TEST_ERROR(title) printf("ERROR %s\n", title); return FALSE;
#define TEST_OK(title)    printf("OK    %s\n", title); return TRUE;

#define TRACE_E_CODE printf("ERROR: %d\n", CST_last_error())
/*
#define TEST_BEGIN(title) int all_ok = TRUE; int result; TEST_TITLE(title);
#define TEST_END return all_ok;

#define TEST_DO(test) \
    result = (test); \
    all_ok = result && all_ok;
*/
#define TEST_DO_SIMPLE(test) \
    if (test) {printf("OK\t%.30s (line %i in %s)\n",  #test, __LINE__, __FILE__); param->counter_ok++;} \
    else      {printf("ERR\t%.30s (line %i in %s)\n", #test, __LINE__, __FILE__); param->counter_err++;}

#define TEST_DO_FATAL(test) \
    if (!(test)) {printf("ERR\t%.30s (line %i in %s)\n", #test, __LINE__, __FILE__); exit(1);} \
    else {printf("OK\t%.30s (line %i in %s)\n",  #test, __LINE__, __FILE__); param->counter_ok++;}

/* Helper functions */
    // Load cert from PEM file
    X509 *test_load_cert(char *filename);
    EVP_PKEY * test_load_private_key(char *filename, unsigned char *password);
    EVP_PKEY * test_load_public_key(char *filename);

    // Return hex view of buffer 
    extern unsigned char *buffer_to_hex(unsigned char *buffer, int size);

    // Compare string 'must' with result of function 'f' with param 'cert'
    typedef char *(*FFingerprint) (X509 * x);
    int test_cmp(char *must, X509 * cert, FFingerprint f);
    gboolean compare_key(EVP_PKEY * a, EVP_PKEY * b, const gboolean pub);

    void printOk(char *message);
    void printErr(char *message);
    void free_stack_X509(STACK_OF(X509) * list);
    void free_array_EVP_PKEY(EVP_PKEY ** arr);


/* Test functions */

    void test_import(PARAM * param);
    void test_search(PARAM * param);
    void test_chain(PARAM * param);
    void test_fingerprint(PARAM * param);
    void test_serial(PARAM * param);
    void test_other_prop(PARAM * param);
    void test_openssl(PARAM * param);

    void test_assign(PARAM * param);
    void test_set_default(PARAM * param);
    void test_get_default(PARAM * param);
    void test_set_purpose(PARAM * param);
    void test_set_purpose_ca(PARAM * param);
    void test_set_folder(PARAM * param);
    void test_get_purpose(PARAM * param);
    void test_get_folder(PARAM * param);
    void test_revoked(PARAM * param);
    void test_export(PARAM * param);
    void test_date(PARAM * param);
    void test_delete(PARAM * param);
    void test_delete_assigned_key(PARAM * param);
    void test_backup(PARAM * param);
    void test_verify(PARAM * param);

    void test_capab_set(PARAM * param);
    void test_capab_get(PARAM * param);
    
    void test_open(PARAM * param);
    void test_open_crashed(PARAM * param);
    void test_multi_process(PARAM * param);
    
#ifdef __cplusplus
}
#endif
#endif                          /* TEST_H_ */
