/* Certificate Management library
 * 
 * Copyright (C) 2005 Nokia. All rights reserved.
 * Author: Ed Bartosh <Eduard.Bartosh@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/**
   @file cst_t.h

   Certificate storage API (internal)
*/

#ifndef CST_T_H_
#define CST_T_H_


#include "cst.h"
#include "cst_const.h"
#include "cst_helper.h"
#include "cst_crypt.h"
#include "cst_cert.h"
#include "cst_key.h"
#include "cst_crl.h"

#include <glib.h>

#include <openssl/pem.h>
#include <openssl/bio.h>
#include <openssl/evp.h>

#include <sys/types.h>
#include <limits.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/file.h>


#ifdef __cplusplus
extern "C" {
#endif


/**
    Set error code
*/
    int CST_error(int error_code);


/**
    Scan file for make index structure
*/
    int initial_scan(CST * st);


/**
    Load info from file-storage
*/
    int cst_load(CST * st, const unsigned char *password);

/**
    Internal assign
*/
    int cst_assign(CST * st, const t_seqnum certID, const t_seqnum keyID);

/**
    Return next certID
*/      
t_seqnum cst_next_cert_uid(CST * st);

/**
    Return next keyID
*/    
t_seqnum cst_next_key_uid(CST * st);

/**
    Check changes while last full scan
*/    
gboolean cst_changed(CST * st);

DB * cst_dbopen(const char *filename, const int mode);

#ifdef __cplusplus
}
#endif
#endif                          /* CST_T_H_ */
