/**
 * @file favicon_cache.c Liferea favicon handling
 * 
 * Copyright (C) 2004 Nathan J. Conrad <t98502@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <hildon/hildon-defines.h>

#include <glib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <osso-log.h>
#include "cache_handling.h"

#include "cache_favicon.h"


/************************************************************************/
/*                        PUBLIC FUNCTIONS                              */
/************************************************************************/

GdkPixbuf *rsslib_favicon_load(gchar *filename_id)
{
    struct stat statinfo;
    gchar *pngfilename = NULL, *xpmfilename = NULL;
    GdkPixbuf *pixbuf = NULL,*pixbuf_temp=NULL;
    GError *error = NULL;

    /* try to load a saved favicon */
    pngfilename =
	common_create_cache_filename("cache" G_DIR_SEPARATOR_S "favicons",
				     filename_id, "png");
    xpmfilename =
	common_create_cache_filename("cache" G_DIR_SEPARATOR_S "favicons",
				     filename_id, "xpm");

    if (0 == stat((const char *) pngfilename, &statinfo)) {
	pixbuf = gdk_pixbuf_new_from_file(pngfilename, &error);
	if (pixbuf != NULL) {
	    pixbuf_temp = gdk_pixbuf_scale_simple(pixbuf,
					       HILDON_ICON_PIXEL_SIZE_SMALL,
					       HILDON_ICON_PIXEL_SIZE_SMALL,
					       GDK_INTERP_BILINEAR);
	    g_object_unref(pixbuf);
	} else {		/* Error */
	    ULOG_DEBUG("Failed to load pixbuf file: %s: %s\n",
		       pngfilename, error->message);
	    /*fprintf (stderr, "Failed to load pixbuf file: %s: %s\n",
	       pngfilename, error->message); */
	    g_error_free(error);
	}

    } else {
	/* FIXME: remove this migration code when time comes */
	if (g_file_test(xpmfilename, G_FILE_TEST_EXISTS)) {
	    pixbuf = gdk_pixbuf_new_from_file(xpmfilename, &error);
	    if (pixbuf) {
		pixbuf_temp =
		    gdk_pixbuf_scale_simple(pixbuf, 16, 16,
					    GDK_INTERP_BILINEAR);
		gdk_pixbuf_save(pixbuf, pngfilename, "png", NULL, NULL);
		g_object_unref(pixbuf);
	    } else {		/* Error */
		ULOG_DEBUG("Failed to load pixbuf file: %s: %s\n",
			   xpmfilename, error->message);

		g_error_free(error);
	    }
	    unlink(xpmfilename);
	}
    }
    g_free(pngfilename);
    g_free(xpmfilename);
    return pixbuf_temp;

}

void rsslib_favicon_remove(gchar *filename_id)
{
    gchar *filename = NULL;

    /* try to load a saved favicon */
    filename =
	common_create_cache_filename("cache" G_DIR_SEPARATOR_S "favicons",
				     filename_id, "png");
    if (g_file_test(filename, G_FILE_TEST_EXISTS)) {
	if (0 != unlink(filename))
	    /* What can we do? The file probably doesn't exist. Or permissions are wrong. Oh well.... */
	    ;
    }
    g_free(filename);
}
