#!/usr/bin/python

import re
import os
import sys
import shutil
from test import *

def build_dir(exe):
    t = get_gcda(exe)
    a = re.search("(/.*)/src/obexsrv.*" ,t)
    return a.groups()[0]

def gen_cov_info(build_dir):
    if os.path.exists('coverage'):
        shutil.rmtree('coverage')
    os.mkdir('coverage')
    os.chdir('coverage')
    os.system('lcov -d ' + build_dir + ' -z')
    os.system('lcov -d ' + build_dir + ' -c -o clinkc.info')
    os.system('genhtml clinkc.info')

exe = '../src/obexsrv'
if is_coverage(exe):
    bdir = build_dir(exe)
    gen_cov_info(bdir)

sys.exit(0)
