#include <common.h>
#include <assert.h>
#include <bluetooth/hci.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <bluetooth/rfcomm.h>

void get_dev(char addr[18])
{
	int ctl = socket(AF_BLUETOOTH, SOCK_RAW, BTPROTO_HCI);
	assert(ctl >= 0);

	int r;
	struct hci_dev_info di;
	memset(&di, 0, sizeof(di));

	struct hci_dev_list_req *dl = malloc(HCI_MAX_DEV * sizeof(struct hci_dev_req) + sizeof(uint16_t));
	dl->dev_num = HCI_MAX_DEV;
	r = ioctl(ctl, HCIGETDEVLIST, (void *) dl);
	assert(r >= 0);

	struct hci_dev_req *dr = dl->dev_req;
	di.dev_id = dr->dev_id;
	r = ioctl(ctl, HCIGETDEVINFO, (void *) &di);
	assert(r >= 0);

	ba2str(&di.bdaddr, addr);
	free(dl);
}

int get_connected_sock(int channel) {
	char dest[18];
	get_dev(dest);
	printf("%s\n", dest);

	int sock = socket(AF_BLUETOOTH, SOCK_STREAM, BTPROTO_RFCOMM);
	assert(sock >= 0);

	struct sockaddr_rc  addr;
	memset(&addr, 0, sizeof(addr));

	addr.rc_family = AF_BLUETOOTH;
	addr.rc_channel = channel;
	str2ba(dest, &addr.rc_bdaddr);

	int r = connect(sock, (struct sockaddr *)&addr, sizeof(addr));
	assert(r == 0);
	return sock;
}

GwObex *setup(const gchar *uuid) {
	int channel = 1;
	int sock = get_connected_sock(channel);

	gint error;
	GwObex *gwo = gw_obex_setup_fd(sock, uuid, 0, NULL, &error);
	assert(gwo != NULL);
	return gwo;
}

static gboolean request_done;

void request_sync(obex_t *handle, obex_object_t *object) {
	OBEX_Request(handle, object);
	request_done = FALSE;
	while (!request_done) {
		OBEX_HandleInput(handle, 10);
	}
}

static void obex_writestream(obex_t *handle, obex_object_t *object) {
	obex_headerdata_t hv;
        hv.bs = NULL;
        OBEX_ObjectAddHeader(handle, object, OBEX_HDR_BODY,
                hv, 0, OBEX_FL_STREAM_DATAEND);
}

static void obex_event_handler(obex_t *handle, obex_object_t *object, int mode,
                               int event, int obex_cmd, int obex_rsp) {
	switch (event) {
	case OBEX_EV_REQDONE:
		request_done = TRUE;
		break;
	case OBEX_EV_STREAMEMPTY:
		obex_writestream(handle, object);
		break;
	default:
		printf("unknown event %d\n", event);
		assert(0);
	}
}

static obex_t *gw_obex_setup_fd2(int fd, const gchar *uuid, gint uuid_len,
                         GMainContext *context, gint *error) {
    obex_t *handle;

    handle = OBEX_Init(OBEX_TRANS_FD, obex_event_handler, 0);
    OBEX_SetTransportMTU(handle, 4096, 32767);
    FdOBEX_TransportSetup(handle, fd, fd, 0);

    obex_object_t *object = OBEX_ObjectNew(handle, OBEX_CMD_CONNECT);
    request_sync(handle, object);

    return handle;
}

obex_t *setup2(const gchar *uuid) {
	int channel = 1;
	int sock = get_connected_sock(channel);

	gint error;
	return gw_obex_setup_fd2(sock, uuid, 0, NULL, &error);
}
