/**
  @file daemon.h

  This module contains functions related to daemon behaviour.

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2006 Nokia Corporation. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _DAEMON_H_
#define _DAEMON_H_

/** Remove the pid file
 * @param pidfile Filename to operate on
 * @returns TRUE on success, FALSE on failure
 */
gboolean remove_pid(const char *pidfile);

/** Check if another instance is running
 * @param pidfile Filename to operate on
 * @returns the pid of the other instance if one is found, else 0
 */
gint check_pid(const char *pidfile);

/** Write our own pid to the pid file
 * @param pidfile Filename to operate on
 * @returns TRUE on success, FALSE on failure
 */
gboolean write_pid(const char *pidfile);

#endif /* _DAEMON_H_ */
