/*
 * This file is part of DSP Gateway version 3.3.1
 *
 * Copyright (C) 2004-2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Toshihiro Kobayashi <toshihiro.kobayashi@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "dsp-user.h"
#include "coff-c55x.h"

#define VERSION_STR	"3.3"
#define IFVER_STR	"3.3"	/* kernel I/F version name */

#define CTLDEVNM	"/dev/dspctl/ctl"
#define TWCHDEVNM	"/dev/dspctl/twch"
#define DSPMEMDEVNM	"/dev/dspctl/mem"
#define TASKDEV_DIR	"/dev/dsptask"

#include "dspcompat.h"

struct dspgw_version {
	unsigned short major;
	unsigned short minor;
	unsigned short extra1;
	unsigned short extra2;
};

extern unsigned long load_coff(char *coffname);
extern int read_dspgw_version(struct dspgw_version *version, char *coffname);
