#include <time.h>
#include <gtk/gtk.h>

#include <scwview.h>
#include <scwentry.h>

#define ITEM_COUNT 10
#define INTERVAL 2000


GtkWidget *win;
ScwView *view;

void delete_win (GtkWidget *widget, gpointer user_data)
{
  gtk_widget_destroy (widget);
  gtk_main_quit ();
}

void on_activated (ScwView *view, gchar *id, gchar *action_data, gpointer user_data)
{
  g_print ("Activated id=%s, data=%s\n", id, action_data);
}

GRand *rng;
guint count;
GtkTreeModel *model1;
GtkTreeModel *model2;

GtkEntry *range1;
GtkEntry *range2;

gboolean append_one (GtkButton *button, gpointer data);
gboolean prepend_one (GtkButton *button, gpointer data);
gboolean insert_random (GtkButton *button, gpointer data);
gboolean change_random (GtkButton *button, gpointer data);
gboolean remove_first (GtkButton *button, gpointer data);
gboolean remove_random (GtkButton *button, gpointer data);
gboolean switch_model1 (GtkButton *button, gpointer data);
gboolean switch_model2 (GtkButton *button, gpointer data);

gboolean jump_to (GtkButton *button, gpointer data)
{
  const gchar *text;
  GtkTreePath *path;
  
  text = gtk_entry_get_text(GTK_ENTRY(data));
  
  if (text == NULL)
    return;
  
  scw_view_scroll_to_row(view, text);
}

gboolean hide_column (GtkButton *button, gpointer data)
{
  const gchar *text;
  GtkTreePath *path;
  
  text = gtk_entry_get_text(GTK_ENTRY(data));
  
  if (text == NULL)
    return;
  
  scw_view_set_column_visible(view, atoi(text), !scw_view_get_column_visible(view, atoi(text)));
}

gboolean jump_to_end (GtkButton *button, gpointer data)
{
  scw_view_scroll_to_end(SCW_VIEW(data));
}

gboolean append_one (GtkButton *button, gpointer data)
{
  gchar *str = g_strdup_printf ("[<b>%i</b> %p]", count++, data);
  GtkTreeIter iter;
  GtkTreeModel *model;

  g_return_if_fail (data != NULL);
  g_return_if_fail (SCW_IS_VIEW(data));

  g_object_get(G_OBJECT(data), "model", &model, NULL);

  gtk_list_store_append (GTK_LIST_STORE (model), &iter);
  gtk_list_store_set (GTK_LIST_STORE (model), &iter,
                      0, time(NULL),
                      1, gdk_pixbuf_new_from_file_at_size ("/usr/share/pixmaps/debian-logo.png",
                                                           24, 24,
                                                           NULL),
                      2, str,
                      3, "This <action id='poop'>row</action> was <icon id='gtk-close'/><b>appended</b> ",
                      -1);
  
  g_free (str);
  
}

gboolean prepend_one (GtkButton *button, gpointer data)
{
  gchar *str;
  GtkTreeIter iter;
  GtkTreeModel *model;

  g_return_if_fail (data != NULL);
  g_return_if_fail (SCW_IS_VIEW(data));

  g_object_get(G_OBJECT(data), "model", &model, NULL);

  str = g_strdup_printf ("[<action id='%i'>%p</action>]", count++, data);
  gtk_list_store_prepend (GTK_LIST_STORE (model), &iter);
  gtk_list_store_set (GTK_LIST_STORE (model), &iter,
                      0, time(NULL),
                      1, gdk_pixbuf_new_from_file_at_size ("/usr/share/pixmaps/debian-logo.png",
                                                           24, 24,
                                                           NULL),
                      2, str,
                      3, "This <action id='prepend'>row</action> was <icon id='gtk-add'><b>prepended</b> ",
                      -1);
  g_free (str);

}

gboolean insert_random (GtkButton *button, gpointer data)
{
  gint i;
  GtkTreeIter iter;
  GtkTreeModel *model;

  g_return_if_fail (data != NULL);
  g_return_if_fail (SCW_IS_VIEW(data));

  g_object_get(G_OBJECT(data), "model", &model, NULL);


  i = gtk_tree_model_iter_n_children (GTK_TREE_MODEL(model), NULL);

  if (i > 0)
    {
      gchar *str = g_strdup_printf ("[<b>%i</b> %p]", count++, data);
      gtk_list_store_insert (GTK_LIST_STORE (model), &iter,
                              g_rand_int_range (rng, 0, i));
                              
      gtk_list_store_set (GTK_LIST_STORE (model), &iter,
                          0, time(NULL),
                          1, gdk_pixbuf_new_from_file_at_size ("/usr/share/pixmaps/debian-logo.png",
                                                                24, 24,
                                                                NULL),
                          2, str,
                          3, "This <action id='random'>row</action> was <icon id='gtk-open'><u>random</u>",
                          -1);
      g_free (str);
    }
    
}

gboolean change_random (GtkButton *button, gpointer data)
{
  gint i;
  GtkTreeIter iter;
  GtkTreeModel *model;

  g_return_if_fail (data != NULL);
  g_return_if_fail (SCW_IS_VIEW(data));

  g_object_get(G_OBJECT(data), "model", &model, NULL);

  i = gtk_tree_model_iter_n_children (GTK_TREE_MODEL(model), NULL);

  if (i > 0)
    {
      gchar *str = g_strdup_printf ("[<b>%i</b> %p]", count++, data);
      gtk_tree_model_iter_nth_child (GTK_TREE_MODEL(model), &iter, NULL,
                                     g_rand_int_range (rng, 0, i));
                              
      gtk_list_store_set (GTK_LIST_STORE (model), &iter,
                          2, str,
                          3, "This <action id='changed'>row</action> was <icon id='gtk-new'><big>changed</big>",
                          -1);
      g_free (str);
    }
    
}

gboolean remove_random (GtkButton *button, gpointer data)
{
  gint i;
  GtkTreeIter iter;
  GtkTreeModel *model;

  g_return_if_fail (data != NULL);
  g_return_if_fail (SCW_IS_VIEW(data));

  g_object_get(G_OBJECT(data), "model", &model, NULL);

  i = gtk_tree_model_iter_n_children (GTK_TREE_MODEL(model), NULL);

  if (i > 0)
    {
      gtk_tree_model_iter_nth_child (GTK_TREE_MODEL(model), &iter, NULL,
                                     g_rand_int_range (rng, 0, i));
      gtk_list_store_remove (GTK_LIST_STORE (model), &iter);
    }
    
}


gboolean remove_first (GtkButton *button, gpointer data)
{
  GtkTreeIter iter;
  GtkTreeModel *model;

  g_return_if_fail (data != NULL);
  g_return_if_fail (SCW_IS_VIEW(data));

  g_object_get(G_OBJECT(data), "model", &model, NULL);


  if (gtk_tree_model_get_iter_first (GTK_TREE_MODEL (model), &iter))
    {
      gtk_list_store_remove (GTK_LIST_STORE (model), &iter);
    }
  else
    {
      gtk_widget_destroy (win);
      gtk_main_quit ();
      return FALSE;
    }

  return TRUE;
}

gboolean switch_model1 (GtkButton *button, gpointer data)
{
  g_return_if_fail (data != NULL);
  g_return_if_fail (SCW_IS_VIEW (data));
/*  
  g_print ("Swithcing to model %p\n", model1);  
*/
  g_object_set (G_OBJECT(data), "model", model1, NULL);

  return FALSE;
}

gboolean switch_model2 (GtkButton *button, gpointer data)
{
  g_return_if_fail (data != NULL);
  g_return_if_fail (SCW_IS_VIEW (data));
/*
  g_print ("Swithcing to model %p\n", model2);  
*/
  g_object_set (G_OBJECT(data), "model", model2, NULL);
  
  return FALSE;
}

gboolean select_range (GtkButton *button, gpointer data)
{
  const gchar *r1;
  const gchar *r2;
  g_return_if_fail (data != NULL);
  g_return_if_fail (SCW_IS_VIEW (data));

  r1 = gtk_entry_get_text(range1);
  r2 = gtk_entry_get_text(range2);
  
  scw_view_select_rows(view, r1, r2);
  
  return FALSE;
}



int main (int argc, char **argv)
{
  int i;
  GtkWidget *vbox;
  GtkWidget *bbox;
  GtkWidget *bbox2;
  GtkWidget *bbox3;
  GtkWidget *bbox4;
  GtkWidget *button;
  GtkWidget *entry;
  GtkWidget *widget;
  GtkWidget *sw;
  GtkTreeIter iter;
  GtkTreeIter iter2;
 
  count = 0;
  rng = g_rand_new ();
  
/*
  g_log_set_always_fatal (G_LOG_LEVEL_WARNING | G_LOG_LEVEL_CRITICAL);
*/ 
  gtk_init (&argc, &argv);
  gtk_rc_parse_string ("style \"test\" "
                       "{ "
                       "ScwView::alternate-row-colors = 1 "
                       "ScwView::row-padding = 2 "
                       "ScwView::column-spacing = 10 "
                       "text[NORMAL] = \"#303030\" "
                       "text[ACTIVE] = \"#000000\" "
                       "text[SELECTED] = \"#000000\" "
                       "text[PRELIGHT] = \"#5050ff\" "
                       "base[NORMAL] = \"#FFFFFF\" "
                       "base[SELECTED] = \"#ded3d6\" "
                       "} class \"ScwView\" style \"test\" ");

  win = GTK_WIDGET (g_object_new (GTK_TYPE_WINDOW, NULL));
  gtk_widget_set_size_request (win, 400, 200);

  model1 = GTK_TREE_MODEL (gtk_list_store_new (4,
                                              SCW_TYPE_TIMESTAMP,
                                              GDK_TYPE_PIXBUF,
                                              SCW_TYPE_PRESENCE,
                                              G_TYPE_STRING));
  model2 = GTK_TREE_MODEL (gtk_list_store_new (4,
                                              SCW_TYPE_TIMESTAMP,
                                              GDK_TYPE_PIXBUF,
                                              SCW_TYPE_PRESENCE,
                                              G_TYPE_STRING));

  widget = GTK_WIDGET (g_object_new (SCW_TYPE_VIEW,
                                    "model", model1,
                                    "align-presences", TRUE,
                                    "presence-alignment", PANGO_ALIGN_LEFT,
                                    "scroll-on-append", TRUE,
                                    NULL));

  view = SCW_VIEW (widget);

  sw = GTK_WIDGET (g_object_new (GTK_TYPE_SCROLLED_WINDOW,
                                 "hadjustment", NULL,
                                 "vadjustment", NULL,
                                 "hscrollbar-policy", GTK_POLICY_NEVER,
                                 "vscrollbar-policy", GTK_POLICY_AUTOMATIC,
                                  NULL));

  vbox = GTK_WIDGET (g_object_new (GTK_TYPE_VBOX, NULL));
  bbox = GTK_WIDGET (g_object_new (GTK_TYPE_HBOX, NULL));
  bbox2 = GTK_WIDGET (g_object_new (GTK_TYPE_HBOX, NULL));
  bbox3 = GTK_WIDGET (g_object_new (GTK_TYPE_HBOX, NULL));
  bbox4 = GTK_WIDGET (g_object_new (GTK_TYPE_HBOX, NULL));

  gtk_container_add (GTK_CONTAINER (sw), widget);
  gtk_container_add (GTK_CONTAINER (vbox), sw);
  gtk_box_pack_end (GTK_BOX (vbox), bbox4, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), bbox3, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), bbox2, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), bbox, FALSE, FALSE, 0);

  button = GTK_WIDGET (g_object_new (GTK_TYPE_BUTTON,
                                     "label", "Append",
                                     NULL));
  g_signal_connect(G_OBJECT(button), "clicked",
                   G_CALLBACK(append_one), view);
  gtk_container_add (GTK_CONTAINER (bbox), button);

  button = GTK_WIDGET (g_object_new (GTK_TYPE_BUTTON,
                                     "label", "Prepend",
                                     NULL));
  g_signal_connect(G_OBJECT(button), "clicked",
                   G_CALLBACK(prepend_one), view);
  gtk_container_add (GTK_CONTAINER (bbox), button);

  entry = GTK_WIDGET (g_object_new (GTK_TYPE_ENTRY,
                                     "text", "10",
                                     NULL));
  gtk_container_add (GTK_CONTAINER (bbox), entry);
  button = GTK_WIDGET (g_object_new (GTK_TYPE_BUTTON,
                                     "label", "Jump to",
                                     NULL));
  g_signal_connect(G_OBJECT(button), "clicked",
                   G_CALLBACK(jump_to), entry);
  gtk_container_add (GTK_CONTAINER (bbox), button);

  button = GTK_WIDGET (g_object_new (GTK_TYPE_BUTTON,
                                     "label", "Insert random",
                                     NULL));
  g_signal_connect(G_OBJECT(button), "clicked",
                   G_CALLBACK(insert_random), view);
  gtk_container_add (GTK_CONTAINER (bbox2), button);

  button = GTK_WIDGET (g_object_new (GTK_TYPE_BUTTON,
                                     "label", "Change random",
                                     NULL));
  g_signal_connect(G_OBJECT(button), "clicked",
                   G_CALLBACK(change_random), view);
  gtk_container_add (GTK_CONTAINER (bbox2), button);

  button = GTK_WIDGET (g_object_new (GTK_TYPE_BUTTON,
                                     "label", "Remove random",
                                     NULL));
  g_signal_connect(G_OBJECT(button), "clicked",
                   G_CALLBACK(remove_random), view);
  gtk_container_add (GTK_CONTAINER (bbox2), button);

  button = GTK_WIDGET (g_object_new (GTK_TYPE_BUTTON,
                                     "label", "Jump to end",
                                     NULL));
  g_signal_connect(G_OBJECT(button), "clicked",
                   G_CALLBACK(jump_to_end), widget);
  gtk_container_add (GTK_CONTAINER (bbox2), button);

  entry = GTK_WIDGET (g_object_new (GTK_TYPE_ENTRY,
                                     "text", "1",
                                     NULL));
  gtk_container_add (GTK_CONTAINER (bbox3), entry);
  button = GTK_WIDGET (g_object_new (GTK_TYPE_BUTTON,
                                     "label", "Hide column",
                                     NULL));
  g_signal_connect(G_OBJECT(button), "clicked",
                   G_CALLBACK(hide_column), entry);
  gtk_container_add (GTK_CONTAINER (bbox3), button);

  button = GTK_WIDGET (g_object_new (GTK_TYPE_BUTTON,
                                     "label", "Model 1",
                                     NULL));
  g_signal_connect(G_OBJECT(button), "clicked",
                   G_CALLBACK(switch_model1), view);
  gtk_container_add (GTK_CONTAINER (bbox3), button);
  button = GTK_WIDGET (g_object_new (GTK_TYPE_BUTTON,
                                     "label", "Model 2",
                                     NULL));
  g_signal_connect(G_OBJECT(button), "clicked",
                   G_CALLBACK(switch_model2), view);
  gtk_container_add (GTK_CONTAINER (bbox3), button);

  entry = GTK_WIDGET (g_object_new (GTK_TYPE_ENTRY,
                                     "text", "0",
                                     NULL));
  gtk_container_add (GTK_CONTAINER (bbox4), entry);
  range1 = GTK_ENTRY(entry);
  entry = GTK_WIDGET (g_object_new (GTK_TYPE_ENTRY,
                                     "text", "1",
                                     NULL));
  gtk_container_add (GTK_CONTAINER (bbox4), entry);
  range2 = GTK_ENTRY(entry);
  button = GTK_WIDGET (g_object_new (GTK_TYPE_BUTTON,
                                     "label", "Select range",
                                     NULL));
  g_signal_connect(G_OBJECT(button), "clicked",
                   G_CALLBACK(select_range), view);
  gtk_container_add (GTK_CONTAINER (bbox4), button);


  g_signal_connect (G_OBJECT (widget), "activate",
                    G_CALLBACK (on_activated), NULL);
  g_signal_connect (G_OBJECT (win), "delete-event",
                    G_CALLBACK (delete_win), NULL);
  gtk_container_add (GTK_CONTAINER (win), vbox);
  gtk_widget_show_all (win);


  gtk_main();

  return (0);
}
