/*
 * This file is part of hello-world-app
 *
 * Copyright (C) 2006-2008 Nokia Corporation. All rights reserved.
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the package
 * root directory.
 *
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>

#include <glib.h>
#include <gtk/gtk.h>

#include <libhildondesktop/libhildondesktop.h>

#include "hello-world-home.h"
#include "libhelloworld.h"


HD_DEFINE_PLUGIN (HelloHomePlugin, hello_home_plugin, HILDON_DESKTOP_TYPE_HOME_ITEM);

static void
hello_home_plugin_init (HelloHomePlugin *home_plugin)
{
  GtkWidget *button;

  button = hello_world_button_new (10);
  g_signal_connect (button, "clicked",
		    G_CALLBACK (hello_world_dialog_show),
		    NULL);

  gtk_widget_show_all (button);

  /* Set the resizing behavior */
  hildon_desktop_home_item_set_resize_type (HILDON_DESKTOP_HOME_ITEM (home_plugin),
                                            HILDON_DESKTOP_HOME_ITEM_RESIZE_BOTH);

  gtk_container_add (GTK_CONTAINER (home_plugin), button);
}

static void
hello_home_plugin_class_init (HelloHomePluginClass *class)
{
}

