/*
 * UPnP Browser for Maemo
 *
 * preset_dialog.h
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license,
 * see file COPYING.
 */

#ifndef PRESET_DIALOG_H
#define PRESET_DIALOG_H

#include <gtk/gtk.h>

#define _(String) gettext(String)

typedef struct _PresetDialog
{
	GtkWidget *preset_dialog;
	GtkWidget *dialog_vbox;
	GtkWidget *preset_combo;
	GtkWidget *dialog_action_area;
	GtkWidget *cancel_button;
	GtkWidget *ok_button;

} PresetDialog;

/**
 * Create a preset dialog
 */
PresetDialog* preset_dialog_new();

/**
 * Destroy a preset dialog
 */
void preset_dialog_delete(PresetDialog* dialog);

/**
 * Update the presets from the given renderer device
 *
 * @param dialog The preset dialog
 * @param udn The UDN of the renderer device
 */
void preset_dialog_update(PresetDialog* dialog, gchar* udn);

/**
 * Get the selected text from the preset dialog's combo
 *
 * @param dialog The preset dialog
 */
gchar* preset_dialog_get_selection(PresetDialog* dialog);

/**
 * Displays the preset dialog and invokes the SelectPreset
 * action using the selected preset. Finally destroys
 * the dialog.
 */
void preset_dialog_run();

#endif
