/*
 * UPnP Browser for Maemo
 *
 * preset_dialog.c
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license,
 * see file COPYING.
 */

#ifdef MAEMO
#include <hildon-widgets/gtk-infoprint.h>
#include <hildon-widgets/hildon-defines.h>
#endif

#include <gtk/gtk.h>
#include <libintl.h>
#include <cybergarage/upnp/cdevice.h>
#include <cybergarage/util/cstring.h>

#include <cybergarage/renderingcontrol/crcscontrolpoint.h>
#include <cybergarage/avcontrol/cavcontrolpoint.h>

#include "preset_dialog.h"
#include "now_playing.h"
#include "upnp.h"

PresetDialog* preset_dialog_new()
{
	PresetDialog* dialog = g_new(PresetDialog, 1);
	
	dialog->preset_dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog->preset_dialog),
			     _("Select A Preset"));
	gtk_window_set_type_hint(GTK_WINDOW(dialog->preset_dialog), 
				 GDK_WINDOW_TYPE_HINT_DIALOG);

	dialog->dialog_vbox = GTK_DIALOG(dialog->preset_dialog)->vbox;
	gtk_widget_show(dialog->dialog_vbox);

	dialog->preset_combo = gtk_combo_box_new_text();
	gtk_widget_show(dialog->preset_combo);
	gtk_box_pack_start(GTK_BOX(dialog->dialog_vbox),
			   dialog->preset_combo, TRUE, FALSE, 0);

	dialog->dialog_action_area =
			GTK_DIALOG(dialog->preset_dialog)->action_area;
	gtk_widget_show(dialog->dialog_action_area);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(dialog->dialog_action_area),
				  GTK_BUTTONBOX_END);

	dialog->ok_button = gtk_button_new_with_label("Select");
	gtk_widget_show(dialog->ok_button);
	gtk_dialog_add_action_widget(GTK_DIALOG(dialog->preset_dialog),
				     dialog->ok_button,
				     GTK_RESPONSE_OK);
	GTK_WIDGET_SET_FLAGS(dialog->ok_button, GTK_CAN_DEFAULT);

	dialog->cancel_button = gtk_button_new_with_label("Cancel");
	gtk_widget_show(dialog->cancel_button);
	gtk_dialog_add_action_widget(GTK_DIALOG (dialog->preset_dialog), 
				     dialog->cancel_button, 
				     GTK_RESPONSE_CANCEL);
	GTK_WIDGET_SET_FLAGS(dialog->cancel_button, GTK_CAN_DEFAULT);

	g_object_set(G_OBJECT(dialog->cancel_button), "has-default", TRUE);

	return dialog;
}

void preset_dialog_delete(PresetDialog* dialog)
{
	g_return_if_fail(dialog != NULL);
	
	gtk_object_destroy(GTK_OBJECT(dialog->preset_dialog));
	
	g_free(dialog);
}

void preset_dialog_update(PresetDialog* dialog, gchar* udn)
{
	gchar* presets = NULL;
	CgStringTokenizer* tok = NULL;
	char* preset = NULL;

	g_return_if_fail(udn != NULL);
	g_return_if_fail(dialog != NULL);
	
	if (get_remote_renderer_presets(udn, &presets) == TRUE)
	{
		tok = cg_string_tokenizer_new(presets, ",");
		
		while (cg_string_tokenizer_hasmoretoken(tok))
		{
			preset = cg_string_tokenizer_nexttoken(tok);
			gtk_combo_box_append_text(
				GTK_COMBO_BOX(dialog->preset_combo),
				preset);
		}

		cg_string_tokenizer_delete(tok);
		g_free(presets);
	}
	
	gtk_combo_box_set_active(GTK_COMBO_BOX(dialog->preset_combo), 0);
}

#ifdef MAEMO
gchar* preset_dialog_get_selection(PresetDialog* dialog)
{
	g_return_val_if_fail(dialog != NULL, NULL);

	return gtk_combo_box_get_active_text(
		GTK_COMBO_BOX(dialog->preset_combo));
}
#else
gchar* preset_dialog_get_selection(PresetDialog* dialog)
{
	GtkTreeModel* model = NULL;
	GtkTreeIter iter;
	gchar* preset = NULL;
	
	g_return_val_if_fail(dialog != NULL, NULL);
	
	model = gtk_combo_box_get_model(GTK_COMBO_BOX(dialog->preset_combo));
	g_return_val_if_fail(model != NULL, NULL);
	
	if (gtk_combo_box_get_active_iter(GTK_COMBO_BOX(dialog->preset_combo), 
					  &iter) == TRUE)
	{
		gtk_tree_model_get(model, &iter, 0, &preset);
	}
	
	return preset;
}	
#endif


void preset_dialog_run()
{
	PresetDialog* pdlg = NULL;
	gchar* udn = NULL;
	gchar* name = NULL;
	gchar* uri = NULL;
	gchar* selection = NULL;
	int result = 0;
	
	char* instanceID = "0";
	
	if (get_current_renderer(&udn, &uri, &name) == TRUE)
	{
		pdlg = preset_dialog_new();
		preset_dialog_update(pdlg, udn);
	}
	else
	{
		return;
	}
	
	if (gtk_dialog_run(GTK_DIALOG(pdlg->preset_dialog)) == GTK_RESPONSE_OK)
	{
		selection = preset_dialog_get_selection(pdlg);
		if (selection)
		{
			cg_upnp_controlpoint_lock(controlPoint);

			result = cg_upnp_av_rcs_control_selectpreset(
				cg_upnp_controlpoint_getdevicebyudn(controlPoint, udn),
				NULL,
				&instanceID,
				&selection);

			cg_upnp_controlpoint_unlock(controlPoint);

			if (cg_upnp_av_control_iserrorcodesuccessful(result))
			{
#ifdef MAEMO
				gtk_infoprint(NULL, "Failed");
#else
				fprintf(stderr, "Failed\n");
#endif
			}
		}

		g_free(selection);
	}

	g_free(udn);
	g_free(uri);
	g_free(name);
	
	preset_dialog_delete(pdlg);
}
