/*
 * UPnP Browser for Maemo
 *
 * playlist_dialog.h
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license,
 * see file COPYING.
 */
 
#ifndef PLAYLIST_DIALOG_H
#define PLAYLIST_DIALOG_H

#include <gtk/gtk.h>
#include <cybergarage/util/clist.h>
#include <cybergarage/util/cstring.h>

#include "playlist.h"

enum
{
	PLAYLISTMODEL_COLUMN_NAME = 0,
	PLAYLISTMODEL_COLUMN_URI,
	PLAYLISTMODEL_COLUMN_SERVER,
	PLAYLISTMODEL_COLUMN_RENDERER,
	PLAYLISTMODEL_COLUMNS
};

typedef struct _PlaylistDialog
{
	GtkWidget* playlist_dialog;
	GtkWidget* vbox;

	GtkWidget* dialog_action_area;
	GtkWidget* remove_button;
	GtkWidget* clear_button;
	GtkWidget* close_button;
	
	GtkWidget* playlist_view;
	GtkWidget* scrolled_window;
	GtkListStore* playlist_model;

} PlaylistDialog;

/**
 * Create a playlist dialog
 */
PlaylistDialog* playlist_dialog_new();

/**
 * Create the view & model components for the playlist
 */
void playlist_dialog_create_view_model(PlaylistDialog* dialog);

/**
 * Destroy a playlist dialog
 */
void playlist_dialog_delete(PlaylistDialog* dialog);

/**
 * Update the playlist dialog from the given playlist
 *
 * @param dialog The playlist dialog
 * @param list The playlist
 */
void playlist_dialog_update(PlaylistDialog* dialog, Playlist* list);

/**
 * Get the selected text from the playlist dialog's combo
 *
 * @param dialog The playlist dialog
 */
gchar* playlist_dialog_get_selection(PlaylistDialog* dialog);

/**
 * Displays the playlist dialog and finally destroys it
 *
 */
void playlist_dialog_run();

#endif
