/*
 * UPnP Browser for Maemo
 *
 * now_playing.h
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license,
 * see file COPYING.
 */
 
#ifndef NOW_PLAYING_H
#define NOW_PLAYING_H

#define UPDATE_NOW_PLAYING_INTERVAL 1000
#define RENDERER_COMBO_WIDTH 250

enum {
	RENDERERMODEL_COLUMN_NAME,
	RENDERERMODEL_COLUMN_DEVUDN,
	RENDERERMODEL_COLUMN_CURRENT_URI,
	RENDERERMODEL_COLUMN_CURRENT_NAME,
	RENDERERMODEL_COLUMNS
};

enum {
	RENDERERMODEL_ROW_LOCAL,
	RENDERERMODEL_ROW_FIRST_REMOTE
};

/**
 * Create the "Now Playing" tooba
 */
int create_now_playing_bar();

/**
 * Create the renderer combo & model
 */
int create_renderer_combo_model();

/** 
 * Create the "Now Playing" text view
 */
int create_now_playing_text_view_model();

/**
 * Callback for selecting an item from the renderer combo
 */
void renderer_combo_selection_changed(GtkComboBox *widget,
					gpointer user_data);

/**
 * Update the text displayed in the "Now Playing" area
 *
 */
void update_now_playing_text();


/**
 * Reset the timeout that updates the now playing bar
 *
 * @param seconds Use 0 to disable the timeout,
 *                otherwise give the timeout interval in seconds
 */
void reset_now_playing_update_timeout(guint seconds);

/**
 * Timeout callback to update the now playing area
 */
gboolean now_playing_update_timeout(gpointer data);

/**
 * Update the text displayed in the "Now Playing" area
 * from local renderer
 *
 * @param buffer The text buffer to update
 */
void update_local_now_playing_text(GtkTextBuffer* buffer);

/**
 * Update the list of available renderer devices
 *
 */
void update_renderers();

/**
 * Helper function to get the currently selected renderer device's UDN
 *
 * @param udn The Renderer device's UDN
 * @param uri Cached URI of the last played item
 * @param name Cached name of the last played item
 * @return TRUE if UDN was set; otherwise FALSE
 */
gboolean get_current_renderer(gchar** udn, gchar** uri, gchar** name);

/**
 * Cache the currently playing URI and track name to the renderer model
 *
 * @param uri The URI of the currently playing track (used for comparison)
 * @param trackName The name of the currently playing track
 * @return TRUE if current renderer was updated; otherwise FALSE
 */
gboolean cache_current_track_for_current_renderer(gchar* uri,
						  gchar* trackName);

/**
 * Checks for some actions from the selected device and
 * de/activates widgets according to their presence/absence
 */
void update_active_renderer_widgets();

/**
 * Set the maximum limit for the seek bar. If max_limit results in 0,
 * the seek bar is disabled
 *
 * @param max_limit CurrentTrackDuration (H+:MM:SS) 
 */
void set_seek_bar_limit(gchar* max_limit);

/**
 * Set the maximum limit for the seek bar.
 *
 * @param max_limit The limit in seconds (long)
 */
void set_seek_bar_limit_long(long max_limit);

/**
 * Set the seek bar's position as a TrackDuration string
 *
 */
void set_seek_bar_position(gchar* position);

/**
 * Set the seek bar's position as a long representation (seconds)
 */
void set_seek_bar_position_long(long position);

#endif
