/*
 * UPnP Browser for Maemo
 *
 * helper.h
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license,
 * see file COPYING.
 */

#ifndef HELPER_H
#define HELPER_H

#include <gtk/gtk.h>

/**
 * Extract host from the given absolute URI.
 *
 * @param uri The absolute URI to extract from
 */
gchar* extract_host_from_uri(gchar* uri);

/**
 * Extract port from the given absolute URI.
 *
 * @param uri The absolute URI to extract from
 */
gchar* extract_port_from_uri(gchar* uri);

/**
 * Extract the relative URI from the given absolute URI.
 *
 * @param uri The absolute URI to extract from
 */
gchar* extract_rel_uri_from_uri(gchar* uri);

/**
 * Extract the file name from the given absolute URI.
 *
 * @param uri The absolute URI to extract from
 */
gchar* extract_filename_from_uri(gchar* uri);

/**
 * Save data to a file
 *
 */
gboolean save_data_to_file();

/**
 * Find a device from the tree model by the device's UDN.
 *
 * @param model The Tree model to search from
 * @param udn The UDN to search for
 * @param iter The GtkTreeIter that points to the device node
 * @return TRUE if the device was found; otherwise FALSE
 */
gboolean find_device_from_model(GtkTreeModel* model, 
				char* udn, int udn_col,
				GtkTreeIter* iter);

/**
 * Convert a CurrentTrackDuration data type to long int
 *
 * @param duration A CurrentTrackDuration string (H+:MM:SS[.F+])
 * @return duration as a long int (0 if an error occurs)
 */
long track_duration_to_long(gchar* duration);

/**
 * Convert a long int to CurrentTrackDuration data type
 *
 * @param duration A CurrentTrackDuration string (H+:MM:SS[.F+])
 * @return A newly-created string containing the duration
 */
gchar* long_to_track_duration(long duration);

#endif
