/* 
 * CyberLinkC AV API
 *
 * cavtransport.h
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license,
 * see file COPYING.
 */

#ifndef CG_UPNP_AV_CAVTRANSPORT_H
#define CG_UPNP_AV_CAVTRANSPORT_H

/*****************************************************************************
 * AV Transport Service
 *****************************************************************************/
#define CG_UPNP_AVT_SERVICE_TYPE "urn:schemas-upnp-org:service:AVTransport"

/*****************************************************************************
 * Mandatory actions
 *****************************************************************************/
#define CG_UPNP_AVT_ACTION_SET_AVTRANSPORTURI "SetAVTransportURI"
#define CG_UPNP_AVT_ACTION_GET_MEDIAINFO "GetMediaInfo"
#define CG_UPNP_AVT_ACTION_GET_TRANSPORTINFO "GetTransportInfo"
#define CG_UPNP_AVT_ACTION_GET_POSITIONINFO "GetPositionInfo"
#define CG_UPNP_AVT_ACTION_GET_DEVICECAPABILITIES "GetDeviceCapabilities"
#define CG_UPNP_AVT_ACTION_GET_TRANSPORTSETTINGS "GetTransportSettings"

#define CG_UPNP_AVT_ACTION_STOP "Stop"
#define CG_UPNP_AVT_ACTION_PLAY "Play"
#define CG_UPNP_AVT_ACTION_SEEK "Seek"
#define CG_UPNP_AVT_ACTION_NEXT "Next"
#define CG_UPNP_AVT_ACTION_PREVIOUS "Previous"

/*****************************************************************************
 * Optional actions
 *****************************************************************************/
#define CG_UPNP_AVT_ACTION_SET_NEXTAVTRANSPORTURI "SetNextAVTransportURI"

#define CG_UPNP_AVT_ACTION_PAUSE "Pause"
#define CG_UPNP_AVT_ACTION_RECORD "Record"
#define CG_UPNP_AVT_ACTION_SET_PLAYMODE "SetPlayMode"
#define CG_UPNP_AVT_ACTION_SET_RECORDQUALITYMODE "SetRecordQualityMode"
#define CG_UPNP_AVT_ACTION_GET_CURRENTTRANSPORTACTIONS "GetCurrentTransportActions"

/*****************************************************************************
 * Transport States
 *****************************************************************************/
#define CG_UPNP_AVT_TRANSPORT_STATE_PLAYING "PLAYING"
#define CG_UPNP_AVT_TRANSPORT_STATE_STOPPED "STOPPED"
#define CG_UPNP_AVT_TRANSPORT_STATE_TRANSITIONING "TRANSITIONING"
#define CG_UPNP_AVT_TRANSPORT_STATE_PAUSED_PLAYBACK "PAUSED_PLAYBACK"
#define CG_UPNP_AVT_TRANSPORT_STATE_PAUSED_RECORDING "PAUSED_RECORDING"
#define CG_UPNP_AVT_TRANSPORT_STATE_RECORDING "RECORDING"
#define CG_UPNP_AVT_TRANSPORT_STATE_NO_MEDIA_PRESENT "NO_MEDIA_PRESENT"

/*****************************************************************************
 * Play Modes
 *****************************************************************************/
#define CG_UPNP_AVT_PLAY_MODE_NORMAL "NORMAL"
#define CG_UPNP_AVT_PLAY_MODE_SHUFFLE "SHUFFLE"
#define CG_UPNP_AVT_PLAY_MODE_REPEAT_ONE "REPEAT_ONE"
#define CG_UPNP_AVT_PLAY_MODE_REPEAT_ALL "REPEAT_ALL"
#define CG_UPNP_AVT_PLAY_MODE_RANDOM "RANDOM"
#define CG_UPNP_AVT_PLAY_MODE_DIRECT_1 "DIRECT_1"
#define CG_UPNP_AVT_PLAY_MODE_INTRO "INTRO"

/*****************************************************************************
 * Record Medium Write Status
 *****************************************************************************/
#define CG_UPNP_AVT_WRITE_STATUS_WRITABLE "WRITABLE"
#define CG_UPNP_AVT_WRITE_STATUS_PROTECTED "PROTECTED"
#define CG_UPNP_AVT_WRITE_STATUS_NOT_WRITABLE "NOT_WRITABLE"
#define CG_UPNP_AVT_WRITE_STATUS_UNKNOWN "UNKNOWN"
#define CG_UPNP_AVT_WRITE_STATUS_NOT_IMPLEMENTED "NOT_IMPLEMENTED"

/*****************************************************************************
 * Playback Medium
 *****************************************************************************/
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_UNKNOWN "UNKNOWN"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_DV "DV"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_MINIDV "MINI-DV"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_VHS "VHS"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_WVHS "W-VHS"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_SVHS "S-VHS"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_DVHS "D-VHS"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_VHSC "VHSC"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_VIDEO8 "VIDEO8"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_HI8 "HI8"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_CDROM "CD-ROM"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_CDDA "CD-DA"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_CDR "CD-R"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_CDRW "CD-RW"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_VIDEOCD "VIDEO-CD"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_SACD "SA-CD"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_MDAUDIO "MD-AUDIO"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_MDPICTURE "MD-PICTURE"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_DVDROM "DVD-ROM"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_DVDVIDEO "DVD-VIDEO"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_DVDR "DVD-R"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_DVDPLUSRW "DVD+RW"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_DVDRW "DVD-RW"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_DVDRAM "DVD-RAM"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_DVDAUDIO "DVD-AUDIO"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_DAT "DAT"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_LD "LD"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_HDD "HDD"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_MICROMV "MICRO-MV"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_NETWORK "NETWORK"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_NONE "NONE"
#define CG_UPNP_AVT_PLAYBACK_MEDIUM_NOT_IMPLEMENTED "NOT_IMPLEMENTED"

/*****************************************************************************
 * Record Quality Modes
 *****************************************************************************/
#define CG_UPNP_AVT_RECORD_QUALITY_EP "0:EP"
#define CG_UPNP_AVT_RECORD_QUALITY_LP "1:LP"
#define CG_UPNP_AVT_RECORD_QUALITY_SP "2:SP"
#define CG_UPNP_AVT_RECORD_QUALITY_BASIC "0:BASIC"
#define CG_UPNP_AVT_RECORD_QUALITY_MEDIUM "1:MEDIUM"
#define CG_UPNP_AVT_RECORD_QUALITY_HIGH "2:HIGH"
#define CG_UPNP_AVT_RECORD_QUALITY_NOT_IMPLEMENTED "NOT_IMPLEMENTED"

/*****************************************************************************
 * Seek Modes
 *****************************************************************************/
#define CG_UPNP_AVT_SEEK_MODE_TRACK_NR "TRACK_NR"
#define CG_UPNP_AVT_SEEK_MODE_ABS_TIME "ABS_TIME"
#define CG_UPNP_AVT_SEEK_MODE_REL_TIME "REL_TIME"
#define CG_UPNP_AVT_SEEK_MODE_ABS_COUNT "ABS_COUNT"
#define CG_UPNP_AVT_SEEK_MODE_REL_COUNT "REL_COUNT"
#define CG_UPNP_AVT_SEEK_MODE_CHANNEL_FREQ "CHANNEL_FREQ"
#define CG_UPNP_AVT_SEEK_MODE_TAPE_INDEX "TAPE_INDEX"
#define CG_UPNP_AVT_SEEK_MODE_FRAME "FRAME"

#endif
