/* 
 * CyberLinkC AV API for Control Points
 *
 * cavcontrolpoint.h
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license,
 * see file COPYING.
 */

#ifndef CG_UPNP_AV_CAVCONTROLPOINT_H
#define CG_UPNP_AV_CAVCONTROLPOINT_H

#include <stdarg.h>
#include <cybergarage/typedef.h>
#include <cybergarage/upnp/cservice.h>

/**
 * Invoke an action on a UPnP service
 *
 * @param upnpService The UPnP service
 * @param actionName The name of the action to invoke
 * @param errorString A newly-created error string if the action fails. Pass
 *                    NULL if you don't want to use it.
 * @param ... A list of action-specific arguments
 *
 * @return An integer containing the UPnP status code
 *
 * The list of action-specific arguments is a comma-separated list, 
 * that is organised as pairs of char* ARG_NAME and char** ARG_VALUE.
 * ARG_NAME contains the name of the argument, while ARG_VALUE contains
 * the value of the argument. You don't need to put anything inside OUT
 * arguments, as they are not sent along with the action; their contents
 * are set when the action post returns with OUT values that were received
 * from the peer. Finally, put a single NULL to end the argument list.
 */
int cg_upnp_av_control_invokeaction(CgUpnpService* upnpService,
				    char* actionName,
				    char** errorString,
				    ...);

/**
 * A helper function to set or get dynamic action arguments to/from an action
 *
 * @param action The UPnP action
 * @param inDirection Use TRUE for IN arguments, FALSE for OUT arguments
 * @param va The dynamic argument list, followed by a single NULL
 */
int cg_upnp_av_control_parseactionarguments(CgUpnpAction* action, 
					    BOOL inDirection,
					    va_list* va);

/**
 * Check, whether a UPnP error/status code is actually a success.
 *
 * @param errorCode The error/status code
 *
 * @return TRUE if the code is not an error; otherwise FALSE
 */
BOOL cg_upnp_av_control_iserrorcodesuccessful(int errorCode);

#endif
