/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Leonid Zolotarev <leonid.zolotarev@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#include "gwebpluginlist.h"

/* GWebPluginListIface */

static void
g_web_plugin_list_base_init (gpointer g_class)
{
	static gboolean initialized = FALSE;

	if (!initialized) {
		/* create interface signals here. */
		initialized = TRUE;
	}
}

GType
g_web_plugin_list_get_type (void)
{
    static GType type = 0;
    if (type == 0) {
        static const GTypeInfo info = {
            sizeof (GWebPluginListIface),
            g_web_plugin_list_base_init,   /* base_init */
            NULL,   /* base_finalize */
            NULL,   /* class_init */
            NULL,   /* class_finalize */
            NULL,   /* class_data */
            0,
            0,      /* n_preallocs */
            NULL    /* instance_init */
        };
        type = g_type_register_static (G_TYPE_INTERFACE, "GWebPluginList", &info, 0);
    }
    return type;
}

void
g_web_plugin_list_destroy (GWebPluginList *self)
{
	G_WEB_PLUGIN_LIST_GET_CLASS (self)->destroy (self);
}

GObject*
g_web_plugin_list_get_items (GWebPluginList *self)
{
	return G_WEB_PLUGIN_LIST_GET_CLASS (self)->get_items (self);
}

gint
g_web_plugin_list_get_items_count (GWebPluginList *self)
{
	return G_WEB_PLUGIN_LIST_GET_CLASS (self)->get_items_count (self);
}

const gchar*
g_web_plugin_list_get_item_title (GWebPluginList *self, gint pos)
{
	return G_WEB_PLUGIN_LIST_GET_CLASS (self)->get_item_title (self, pos);
}

const gchar*
g_web_plugin_list_get_item_creator (GWebPluginList *self, gint pos)
{
	return G_WEB_PLUGIN_LIST_GET_CLASS (self)->get_item_creator (self, pos);
}

const gchar*
g_web_plugin_list_get_item_path (GWebPluginList *self, gint pos)
{
	return G_WEB_PLUGIN_LIST_GET_CLASS (self)->get_item_path (self, pos);
}

const gchar*
g_web_plugin_list_get_item_type (GWebPluginList *self, gint pos)
{
	return G_WEB_PLUGIN_LIST_GET_CLASS (self)->get_item_type (self, pos);
}

guint
g_web_plugin_list_get_item_ctype (GWebPluginList *self, gint pos)
{
	return G_WEB_PLUGIN_LIST_GET_CLASS (self)->get_item_ctype (self, pos);
}

guint
g_web_plugin_list_get_item_state (GWebPluginList *self, gint pos)
{
	return G_WEB_PLUGIN_LIST_GET_CLASS (self)->get_item_state (self, pos);
}
