/**
 * screenshot-tool: Simple tool to take a screenshot of the whole screen
 * and save it to a PNG file.
 *
 * Copyright (C) 2005 Nokia Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Tommi Komulainen <tommi.komulainen@nokia.com>
 */
#include <gtk/gtkmain.h>

static gboolean
screenshot (const char *filename, GError **error)
{
  GdkDrawable *root_window;
  int          width, height;
  GdkPixbuf   *pixbuf;
  gboolean     ret;

  root_window = gdk_get_default_root_window ();
  gdk_drawable_get_size (root_window, &width, &height);

  pixbuf = gdk_pixbuf_get_from_drawable (NULL,
					 root_window,
					 gdk_drawable_get_colormap (root_window),
					 0, 0,
					 0, 0,
					 width, height);

  ret = gdk_pixbuf_save (pixbuf, filename, "png", error, NULL);
  g_object_unref (pixbuf);

  return ret;
}

int
main (int argc, char **argv)
{
  const char *filename;
  GError     *error = NULL;

  gtk_init (&argc, &argv);

  if (argc != 2)
    {
      g_printerr ("Usage: %s filename.png\n", g_get_prgname ());
      return 1;
    }
  filename = argv[1];

  if (screenshot (filename, &error))
    return 0;

  g_printerr ("%s: %s\n", g_get_prgname (), error->message);
  g_error_free (error);
  return 1;
}
