#!/usr/bin/python

#doc: close a connection in the middle of a transmission

import sys
from test_btctl import *
import time
import os
import os.path
import signal
from test import *
from test_dbus import *

p = obexsrv()

fname = 'abc'

class my_handler(handler):
    def Progress(self, transfered, size):
        pid = os.getpid()
        os.kill(pid, signal.SIGKILL)

pid = os.fork()
if pid == 0:
    path = '/abc'
    con = get_connection()

    h = my_handler(con, path, fname)

    f     = open('/bin/ls')
    data = f.read()
    f.close()

    transmit(fname, data)

else:
    os.waitpid(pid, 0)
    time.sleep(5)
    t = p.finish()
    os.remove(fname)
    sys.exit(t)
