import sys

try:
    import btctl
    import gobject
except ImportError, e:
    print e
    sys.exit(77)

from test import *

__all__ = ['gobject', 'transmit']

class transmission:
    def __init__(self, fname, data, finishcb):
        self.finishcb = finishcb
        self.data     = data
        self.fname    = fname

        if bt_dev == None:
            sys.exit(77)
        self.client = btctl.ObexClient(bt_dev, 1)
        self.client.connect('complete', self.complete)
        self.client.connect('connected', self.connected)
        self.client.connect('progress', self.progress)
        self.client.connect('error', self.error)

    def send(self):
        self.client.push_data(self.fname, self.data)

    def complete(self, a, b):
        gobject.idle_add(self.finishcb)

    def connected(self, a, b):
        gobject.idle_add(self.send)

    def progress(self, a, b):
        pass

    def error(self, a, b, c):
        sys.exit(1)

def transmit(name, data):
    loop = gobject.MainLoop()
    def quit():
        loop.quit()

    t = transmission(name, data, quit)
    loop.run()
