import re
import popen2
import os
import signal
import time
import sys

__all__ = ['start', 'obexsrv', 'bt_dev', 'pidfile', 'is_coverage', 'get_gcda', 'valgrind_exe']

def get_addrs():
    p = os.popen('hciconfig')
    data = p.read()
    r = p.close()
    assert r == None
    m = re.findall('.*BD Address: (\S+).*', data)

    #need at least two dongles
    assert len(m) >= 2

    return m

bt_dev = None
try:
    bt_dev = get_addrs()[0]
except:
    pass

pidfile = '/tmp/obexsrv.pid'

def get_gcda(exe):
    f = os.popen('strings ' + exe)
    data = f.read()
    f.close()
    a = re.search('/.*\.gcda', data)
    if a == None:
        return None
    return a.group()

def is_coverage(exe):
    t = get_gcda(exe)
    return t != None

class executable:
    def __init__(self, cmd, ignore):
        self.p = popen2.Popen3(cmd, capturestderr = True)
        self.stdin = self.p.tochild
        self.stdout = self.p.fromchild
        self.stderr = self.p.childerr
        self.ignore = ignore

    #returns True if completed successfully
    def finish(self):
        r = self.p.wait()
        if r != 0:
            print self.stderr.read()
        return r

class simple_exe (executable):
    def __init__(self, cmd, ignore):
        executable.__init__(self, cmd, ignore)

class valgrind_exe (executable):
    def __init__(self, cmd, ignore):
        aux = ['/usr/bin/valgrind','--leak-check=full'] + cmd
        executable.__init__(self, aux, ignore)

    def finish(self):
        r = self.p.wait()
        data = self.stderr.read()
        if r != 0:
            print data
            return r
        a = re.search('ERROR SUMMARY: *(.*) err.*', data)
        errors = int(a.groups()[0])
        a = re.search('definitely lost: (.*) bytes', data)
        if a != None:
            a = int(a.groups()[0])
#            if a != 0:
#                errors += 1
        if errors != 0:
            print data
        return errors

def start(cmd, ignore = 0, exe = None):
    if isinstance(cmd, str):
        cmd = ['./' + cmd]
    if not exe:
        exe = cmd[0]
    p     = None
    if is_coverage(exe):
        p = simple_exe(cmd, ignore)
    elif os.path.exists('/usr/bin/valgrind'):
        p = valgrind_exe(cmd, ignore)
    else:
        p = simple_exe(cmd, ignore)
    return p

class obexsrv:
    def __init__(self, opt = []):
        self.running = False
        if os.path.exists(pidfile):
            os.remove(pidfile)
        if bt_dev == None:
            sys.exit(77)
        cmd = ['../src/obexsrv'] + opt
        self.p = start(cmd)
        #<hack>
        time.sleep(3)
        #</hack>
        self.running = True

    def __del__(self):
        if self.running:
            self.finish()

    def finish(self):
        os.kill(self.p.p.pid, signal.SIGINT)
        r = self.p.finish()
        self.running = False
        return r
