/**
  @file log.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2006 Nokia Coproration. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _LOG_H_
#define _LOG_H_

#include <stdlib.h>
#include <glib.h>

/** Log error message */
#ifdef NDEBUG
# define error(...) ((void)(0))
#else
# define error(...) g_warning(__VA_ARGS__)
#endif

/** Log informational message */
#ifdef NDEBUG
# define report(...) ((void)(0))
#else
# define report(...) g_message(__VA_ARGS__)
#endif

#ifdef DEBUG
# define debug(...) g_debug(__VA_ARGS__)
#else
# define debug(...) ((void)(0))
#endif

/** Setup logging functionality
 * @param name Identifier for this program
 * @param use_syslog Use syslog instead of stdout & stderr
 */
void open_log(const char *name, gboolean use_syslog);

/** Print error message and exit */
#define die(...) do {   \
    g_critical(__VA_ARGS__); \
    exit(EXIT_FAILURE); \
} while (0)

#endif /* _LOG_H_ */
