/**
 * @file ossoemailinterface.h
 *
 * This file contains OSSO Email Interface APIs
 *
 * Copyright (C) 2005, 2006 Nokia Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef OSSOEMAILINTERFACE_H_
# define OSSOEMAILINTERFACE_H_

# include <glib.h>
# include <time.h>
# include <syslog.h>

G_BEGIN_DECLS

#define OSSO_EMAIL           "osso_email"
#define SEND_FILES_METHOD    "send_files"
#define SEND_URL_METHOD      "send_url"
#define SEND_MAILTO_METHOD   "send_mailto"
#define GET_FOLDERS_LIST     "get_folders_list"

#define OSSO_EMAIL_SERVICE   "com.nokia.osso_email"
#define OSSO_EMAIL_OBJ_PATH   "/com/nokia/osso_email"

/**
 * definition: this path is relative to the home directory
 */
#define OSSO_EMAIL_STORAGE_PATH "apps/email/Mail"

/**
 * definition: this path is relative to the MMC root directory
 */
#define OSSO_EMAIL_STORAGE_ARCHIVE_PATH ".archive"

/**
 * definition: this path is relative to the home directory
 */
#define OSSO_EMAIL_CONTACTS_PATH ".osso-email/AddressBook.xml"

/** Email and contact plugin unread mails Gconf path info */
#define EMAIL_GCONF_PATH			"/apps/osso/tnemail"
	
#define EMAIL_GCONF_UNREAD_MAIL_COUNT	EMAIL_GCONF_PATH"/UnReadMails"
#define EMAIL_GCONF_CHANGE_STATUS       EMAIL_GCONF_PATH"/ChangeStatus"
#define EMAIL_GCONF_SENDRECV_STATUS     EMAIL_GCONF_PATH"/SendRecvStatus"

#define SEND_RECV_NO_ACCT               0
#define SEND_RECV_DONE                  1
#define SEND_RECV_PROGRESS              2

#define EMAIL_GCONF_UNREAD_MAIL1_MSGID		EMAIL_GCONF_PATH"/Mail1/MsgId"
#define EMAIL_GCONF_UNREAD_MAIL1_FROM		EMAIL_GCONF_PATH"/Mail1/From"
#define EMAIL_GCONF_UNREAD_MAIL1_SUBJECT	EMAIL_GCONF_PATH"/Mail1/Subject"
#define EMAIL_GCONF_UNREAD_MAIL1_HAS_ATTACH	EMAIL_GCONF_PATH"/Mail1/Attachment"

#define EMAIL_GCONF_UNREAD_MAIL2_MSGID		EMAIL_GCONF_PATH"/Mail2/MsgId"
#define EMAIL_GCONF_UNREAD_MAIL2_FROM		EMAIL_GCONF_PATH"/Mail2/From"
#define EMAIL_GCONF_UNREAD_MAIL2_SUBJECT	EMAIL_GCONF_PATH"/Mail2/Subject"
#define EMAIL_GCONF_UNREAD_MAIL2_HAS_ATTACH	EMAIL_GCONF_PATH"/Mail2/Attachment"

#define EMAIL_GCONF_UNREAD_MAIL3_MSGID		EMAIL_GCONF_PATH"/Mail3/MsgId"
#define EMAIL_GCONF_UNREAD_MAIL3_FROM		EMAIL_GCONF_PATH"/Mail3/From"
#define EMAIL_GCONF_UNREAD_MAIL3_SUBJECT	EMAIL_GCONF_PATH"/Mail3/Subject"
#define EMAIL_GCONF_UNREAD_MAIL3_HAS_ATTACH	EMAIL_GCONF_PATH"/Mail3/Attachment"

#define EMAIL_GCONF_UNREAD_MAIL4_MSGID		EMAIL_GCONF_PATH"/Mail4/MsgId"
#define EMAIL_GCONF_UNREAD_MAIL4_FROM		EMAIL_GCONF_PATH"/Mail4/From"
#define EMAIL_GCONF_UNREAD_MAIL4_SUBJECT	EMAIL_GCONF_PATH"/Mail4/Subject"
#define EMAIL_GCONF_UNREAD_MAIL4_HAS_ATTACH	EMAIL_GCONF_PATH"/Mail4/Attachment"

#define EMAIL_GCONF_UNREAD_MAIL5_MSGID		EMAIL_GCONF_PATH"/Mail5/MsgId"
#define EMAIL_GCONF_UNREAD_MAIL5_FROM		EMAIL_GCONF_PATH"/Mail5/From"
#define EMAIL_GCONF_UNREAD_MAIL5_SUBJECT	EMAIL_GCONF_PATH"/Mail5/Subject"
#define EMAIL_GCONF_UNREAD_MAIL5_HAS_ATTACH	EMAIL_GCONF_PATH"/Mail5/Attachment"



/* @}*/
/**
 * \defgroup Common Common features
 */
/* @{*/
/* @}*/
/**
 * \defgroup SendByEmail Send by email
 *
 * Contact people: dirk-jan.binnema@nokia.com
 *
 * The use cases for send by email are:
 *  -# List of files to be attached is given (these are URIs in gnome-vfs format)
 *  -# Url (only url, not the page) to be sent in the email is given
 *     (browser uses this functionality)
 *  -# emailto, wherein the emailaddress (encoded as per RFC 2368) is the
 *     second param (browser uses this functionality)
 *  -# add to Contact

 * @{
 */

/**
 * This function will send a top D-Bus message to the email
 * application with a list of gnomeVFS URI's as argutments.
 *
 * @param osso The library context as returned by #osso_initialize.
 * @param list A GSList of strings -- URI's in GnomeVFS format.
 *
 * @return #OSSO_OK if all goes well, #OSSO_ERROR if an error occurred or
 *  #OSSO_INVALID if some parameter is invalid, #OSSO_RPC_ERROR if an error
 *  occured while sending the dbus message.
 */
osso_return_t 
osso_email_files_email(osso_context_t *osso, GSList *list);

/**
 * This function will send a top D-Bus message to the email
 * application with an gchar* URL as argutment.
 *
 * @todo Do we need to check for URI/URL validity inside libosso?
 *
 * @param osso The library context as returned by #osso_initialize.
 * @param url An URL to send by email.
 * @note should this be a GSList?
 *
 * @return #OSSO_OK if all goes well, #OSSO_ERROR if an error occurred or
 *  #OSSO_INVALID if some parameter is invalid, #OSSO_RPC_ERROR if an error
 *  occured while sending the dbus message.
 */
osso_return_t 
osso_email_url_email(osso_context_t *osso, const gchar *url);

/**
 * This function will cause the email application to be topped
 * with an empty email to the specified recipient opened. This is
 * implemented with the top D-BUS message to the email
 * application.
 *
 * @param osso The library context as returned by #osso_initialize.
 * @param to A GSList of mailto URI strings.
 *
 * @return #OSSO_OK if all goes well, #OSSO_ERROR if an error occurred or
 *  #OSSO_INVALID if some parameter is invalid, #OSSO_RPC_ERROR if an error
 *  occured while sending the dbus message.
 */
osso_return_t 
osso_email_emailto_email(osso_context_t *osso, GSList *to);

/**
   This function is called to get the email folder list to other applications
   (like Global search etc) 

   @param osso The library context as returned by #osso_initialize.
   @return GSList of floders or NULL incase of error
*/
GSList * osso_email_get_folder_list ( osso_context_t * osso );

G_END_DECLS

#endif /* LIBOSSO_H_*/
