/**
 * Copyright (C) 2007 Nokia Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */


#ifndef __OSSOEMAILINTERFACE_MODEST_H__
#define __OSSOEMAILINTERFACE_MODEST_H__

#include <glib.h>
#include <time.h>
#include <syslog.h>

#include "ossoemailinterface.h"

G_BEGIN_DECLS

/* @}*/
/**
 * \defgroup Common Common features
 */
/* @{*/
/* @}*/
/**
 * \defgroup SendByEmail Send by email
 *
 * Contact people: dirk-jan.binnema@nokia.com
 *
 * The use cases for send by email are:
 *  -# List of files to be attached is given (these are URIs in gnome-vfs format)
 *  -# Url (only url, not the page) to be sent in the email is given
 *     (browser uses this functionality)
 *  -# emailto, wherein the emailaddress (encoded as per RFC 2368) is the
 *     second param (browser uses this functionality)
 *  -# add to Contact

 * @{
 */

/**
 * This function will send a top D-Bus message to the email
 * application with a list of gnomeVFS URI's as arguments.
 *
 * @param osso The library context as returned by #osso_initialize.
 * @param list A GSList of strings -- URI's in GnomeVFS format.
 *
 * @return #OSSO_OK if all goes well, #OSSO_ERROR if an error occurred or
 *  #OSSO_INVALID if some parameter is invalid, #OSSO_RPC_ERROR if an error
 *  occured while sending the dbus message.
 */
osso_return_t 
osso_email_files_email_modest (osso_context_t *osso, GSList *list);

/**
 * This function will send a top D-Bus message to the email
 * application with an gchar* URL as argument.
 *
 * @todo Do we need to check for URI/URL validity inside libosso?
 *
 * @param osso The library context as returned by #osso_initialize.
 * @param url An URL to send by email.
 * @note should this be a GSList?
 *
 * @return #OSSO_OK if all goes well, #OSSO_ERROR if an error occurred or
 *  #OSSO_INVALID if some parameter is invalid, #OSSO_RPC_ERROR if an error
 *  occured while sending the dbus message.
 */
osso_return_t 
osso_email_url_email_modest (osso_context_t *osso, const gchar *url);

/**
 * This function will cause the email application to be topped
 * with an empty email to the specified recipients opened. This is
 * implemented with the top D-BUS message to the email
 * application.
 *
 * @param osso The library context as returned by #osso_initialize.
 * @param to A GSList of mailto URI strings.
 *
 * @return #OSSO_OK if all goes well, #OSSO_ERROR if an error occurred or
 *  #OSSO_INVALID if some parameter is invalid, #OSSO_RPC_ERROR if an error
 *  occured while sending the dbus message.
 */
osso_return_t 
osso_email_emailto_email_modest (osso_context_t *osso, GSList *to);

/**
   This function is called to get the email folder list to other applications
   (like Global search etc) 

   @param osso The library context as returned by #osso_initialize.
   @return GSList of floders or NULL incase of error
*/
GSList * osso_email_get_folder_list_modest ( osso_context_t * osso );

G_END_DECLS

#endif /*__OSSOEMAILINTERFACE_MODEST_H__*/
