/**
 *
 * Copyright (C) 2007 Nokia Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef __LIBMODEST_DBUS_CLIENT_H__
#define __LIBMODEST_DBUS_CLIENT_H__

#include <libosso.h>
#include <glib.h>
#include <stdio.h>

gboolean
libmodest_dbus_client_compose_mail (osso_context_t *osso_context, const gchar *to, 
	const gchar *cc, const gchar *bcc, const gchar* subject, const gchar* body, 
	GSList *attachments);
	
gboolean 
libmodest_dbus_client_mail_to (osso_context_t *osso_context, 
	const gchar *mailto_uri);

gboolean 
libmodest_dbus_client_open_message (osso_context_t *osso_context, 
	const gchar *mail_uri);

gboolean 
libmodest_dbus_client_send_and_receive (osso_context_t *osso_context);

gboolean 
libmodest_dbus_client_open_default_inbox (osso_context_t *osso_context);

typedef enum {

	MODEST_DBUS_SEARCH_SUBJECT   = (1 << 0),
	MODEST_DBUS_SEARCH_SENDER    = (1 << 1),
	MODEST_DBUS_SEARCH_RECIPIENT = (1 << 2),
	MODEST_DBUS_SEARCH_SIZE      = (1 << 3),
	MODEST_DBUS_SEARCH_BODY      = (1 << 6)

} ModestDBusSearchFlags;

typedef struct {
	gchar     *msgid; /* E.g. the URI of the message. */
	gchar     *subject;
	gchar     *folder; /* The name, not the URI. */
	gchar     *sender;
	guint64    msize;
	gboolean   has_attachment;
	gboolean   is_unread;
	gint64     timestamp;		 
} ModestSearchHit;


void modest_search_hit_list_free (GList *hits);


gboolean libmodest_dbus_client_search            (osso_context_t          *osso_ctx,
							const gchar             *query,
							const gchar             *folder,
							time_t                   start_date,
							time_t                   end_date,
							guint32                  min_size,
							ModestDBusSearchFlags    flags,
							GList                  **hits);

gboolean libmodest_dbus_client_delete_message   (osso_context_t   *osso_ctx,
							const char       *msg_uri);
							
							
typedef struct {
	gchar     *folder_uri;
	gchar     *folder_name;	 
} ModestFolderResult;

gboolean libmodest_dbus_client_get_folders (osso_context_t *osso_ctx, GList **folders);	

void modest_folder_result_list_free (GList *folders);

													
#endif /* __LIBMODEST_DBUS_CLIENT_H__ */
