/* vim:set ts=2 sw=4 sts=2 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#include <gweb.h>
#include <gwebengine.h>

#ifndef __GMOZILLAWEB_H__
#define __GMOZILLAWEB_H__

G_BEGIN_DECLS

/* GMozillaWeb */

#define G_TYPE_MOZILLA_WEB             (g_mozilla_web_get_type ())
#define G_MOZILLA_WEB(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_MOZILLA_WEB, GMozillaWeb))
#define G_MOZILLA_WEB_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), G_TYPE_MOZILLA_WEB, GMozillaWebClass))
#define G_IS_MOZILLA_WEB(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_MOZILLA_WEB))
#define G_IS_MOZILLA_WEB_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), G_TYPE_MOZILLA_WEB))
#define G_MOZILLA_WEB_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_INTERFACE ((inst), G_TYPE_MOZILLA_WEB, GMozillaWebClass))

#define MAXIMUM_GLOBAL_HISTORY 50  //Moved from C file

typedef struct _GMozillaWebCertContext GMozillaWebCertContext;
typedef struct _GMozillaWeb GMozillaWeb;
typedef struct _GMozillaWebClass GMozillaWebClass;
typedef struct _AnimeCursor AnimeCursor;

/** @struct AnimeCursor
  * Defines animation values
  */
struct _AnimeCursor{
    GdkPixbufAnimation *anime;
    GdkPixbufAnimationIter *anime_iter;
    GMozillaEngine *link_to_engine;
};
            
struct _GMozillaWebCertContext
{
    gpointer cert;
    guint error;
};

/** @struct GMozillaWeb.
  * Defines a Mozilla Web.
  */
struct _GMozillaWeb
{
    GObject parent;          /** < Object parent */
    GObject *global;         /** < Global object */
    GList *logins_list;
    GList *mCertContexts;
    GList *ongoing_download_list;
    gboolean is_configured;
    GSList *disabled_pllist;
    AnimeCursor *anime_cursor;
    GdkCursor *default_cursor;
    gboolean connected;
};

struct _GMozillaWebClass
{
    GObjectClass parent;
    void (*ask_cookie)                 (GObject *, gpointer, gint, const gchar *,
                                        const gchar *, const gchar *, const gchar *,
                                        const gchar *, gboolean, gint, GObject *);
    gint (*modal_dialog)               (GObject *, const gchar *, const gchar *,
                                        gint, gint, gint, gint);
    gboolean (*certificate_dialog)     (GObject *, GObject *);
    void (*certificate_password_dialog)(GObject *, const gchar *,
                                        const gchar *, gchar **);
    void (*certificate_details)        (GObject *, gpointer);
    gint (*on_submit)                  (GObject *);
    gint (*select_match)               (GObject *, gpointer);
    void (*history_added)              (GObject *, const gchar *, GObject *);
    void (*connectivity_status)        (GObject *, gint);
};

GType       g_mozilla_web_get_type      (void);

/** Gets the mozilla web global instance
  * @return The mozilla global instance.
  */
GMozillaWeb* g_mozilla_get_current_web(void);

/** Pauses all not finished downloads
  * @param self The GMozillaWeb object itself
  * @return
  */
void
g_mozilla_web_pause_all_transfer_item (GMozillaWeb *self);

G_END_DECLS

#endif /* __GMOZILLAWEB_H__ */
