/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#include <gwebtransferitem.h>

#include "gtkmozembed_download.h"

#ifndef __GMOZILLATRANSFERITEM_H__
#define __GMOZILLATRANSFERITEM_H__

G_BEGIN_DECLS

#define G_TYPE_MOZILLA_TRANSFER_ITEM             (g_mozilla_transfer_item_get_type ())
#define G_MOZILLA_TRANSFER_ITEM(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_MOZILLA_TRANSFER_ITEM, GMozillaTransferItem))
#define G_MOZILLA_TRANSFER_ITEM_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), G_TYPE_MOZILLA_TRANSFER_ITEM, GMozillaTransferItemClass))
#define G_IS_MOZILLA_TRANSFER_ITEM(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_MOZILLA_TRANSFER_ITEM))
#define G_IS_MOZILLA_TRANSFER_ITEM_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), G_TYPE_MOZILLA_TRANSFER_ITEM))
#define G_MOZILLA_TRANSFER_ITEM_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_INTERFACE ((inst), G_TYPE_MOZILLA_TRANSFER_ITEM, GMozillaTransferItemClass))

/* a macro for creating a new object of our type */
#define GET_NEW (g_object_new(g_mozilla_transfer_item_get_type(), NULL))

typedef struct _GMozillaTransferItem GMozillaTransferItem;
typedef struct _GMozillaTransferItemClass GMozillaTransferItemClass;

/** @struct GMozillaTransferItem.
  * Defines a Mozilla Transfer Item.
  */
struct _GMozillaTransferItem
{
    GObject parent;                     /** < Object parent */
    GObject* item;                      /** < Object item */

    GtkMozEmbedDownload *gtk_moz_embed_download;
    gchar *file_name;
    guint progress_timer_id;
};

struct _GMozillaTransferItemClass
{
    GObjectClass parent;

    void (*started) (GMozillaTransferItem* item);
    void (*completed) (GMozillaTransferItem* item);
    void (*error) (GMozillaTransferItem* item);
    void (*aborted) (GMozillaTransferItem* item);
    void (*progress) (GMozillaTransferItem* item, gulong , gulong , gulong );
};

/** < This structure will be used to registry the signals in the mozilla engine */

GType g_mozilla_transfer_item_get_type (void);

/** Creates a new transfer item's instance
  * @return A transfer item.
  */
GObject* g_mozilla_transfer_item_new (void);

/** Creates a new transfer item's instance with a item passed as a parameter
  * @param item A transfer item.
  * @return A transfer item. 
  */
GObject* g_mozilla_transfer_item_new_with_item (GObject *item);

/** Creates a new transfer item's instance with the URL passed as a parameter
  * @param url An URL.
  * @param filename The file's name.
  * @return A transfer item. 
  */
GObject* g_mozilla_transfer_item_new_with_url  (const gchar *url, const gchar *filename);

/** Holds the instance of GMozillaWeb object
  * @param webglobal The GMozillaWeb object itself
  * @return nothing
  */
void g_mozilla_transfer_item_set_webglobal (GObject *webglobal);

/** Initializes a progress timeout aiming to detect internet/connection problems during downloading
  * @param transferitem Transfer item itseft
  * @return nothing
  */
void init_progress_timeout (GMozillaTransferItem *transferitem);

G_END_DECLS

#endif /* __GMOZILLATRANSFERITEM_H__ */
