/*
 * This file is part of maemopad
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
                     
#ifndef INTERFACE_H
#define INTERFACE_H

#include <gtk/gtk.h>
#include <hildon-1/hildon/hildon-program.h>
#include <appdata.h>

#define _(String) gettext(String)

/* confirmation responses */
#define CONFRESP_YES 1
#define CONFRESP_NO 2
#define CONFRESP_OK 3
#define CONFRESP_CANCEL 4
#define CONFRESP_ERROR 5

#define MAIN_VIEW_NAME "AppUIData"

typedef enum {
    MAEMOPAD_NO_ERROR = 0,
    MAEMOPAD_ERROR_INVALID_URI,
    MAEMOPAD_ERROR_SAVE_FAILED,
    MAEMOPAD_ERROR_OPEN_FAILED
} MaemopadError;

/* Struct to include view's information */
typedef struct _AppUIData AppUIData;
struct _AppUIData
{
    /* Handle to app's data */
    AppData *data;

    /* Fullscreen mode is on (TRUE) or off (FALSE) */
    gboolean fullscreen;

    /* Items for menu */
    GtkWidget *file_item;
    GtkWidget *new_item;
    GtkWidget *open_item;
    GtkWidget *save_item;
    GtkWidget *saveas_item;
    GtkWidget *edit_item;
    GtkWidget *cut_item;
    GtkWidget *copy_item;
    GtkWidget *paste_item;
    /*send via stuff */
    GtkWidget *sendvia_item;
    GtkWidget *sendemail_item;
    GtkWidget *sendbt_item;


    GtkWidget *font_item;
    GtkWidget *fullscreen_item;

    /* Toolbar */
    GtkWidget* toolbar;
    GtkWidget* iconw;
    GtkToolItem* new_tb;
    GtkToolItem* open_tb;
    GtkToolItem* save_tb;
    GtkToolItem* saveas_tb;
    GtkToolItem* separator_tb1;
    GtkToolItem* cut_tb;
    GtkToolItem* copy_tb;
    GtkToolItem* paste_tb;
    GtkToolItem* separator_tb2;
    GtkToolItem* font_tb;
    GtkToolItem* fullscreen_tb;

    /* Textview related */
    GtkWidget* scrolledwindow;   /* textview is under this widget */
    GtkWidget* textview;         /* widget that shows the text */
    GtkTextBuffer* buffer;       /* buffer that contains the text */
    GtkClipboard* clipboard;     /* clipboard for copy/paste */
   
    PangoFontDescription* font_desc;    /* font used in textview */

    gboolean file_edited;     /* tells is our file on view edited */
    gchar* file_name;         /* directory/file under editing */
};

/* Publics: */
AppUIData* interface_main_view_new( AppData* data );
void interface_main_view_destroy( AppUIData* main );
char* interface_file_chooser( AppUIData* main, GtkFileChooserAction action );
PangoFontDescription* interface_font_chooser( AppUIData * main );
gint interface_save_changes_note( AppUIData* main );
void interface_error( MaemopadError me, AppUIData *main );

#endif
