/**
    @file callbacks.c

    Maemo-Blocks callback functions for libshadow

  This file is part of Maemo Blocks

  Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
  http://www.indt.org/maemo
 
  This software is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License
  as published by the Free Software Foundation; either version 2.1 of
  the License, or (at your option) any later version.
 
  This software is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.
 
  You should have received a copy of the GNU Lesser General Public
  License along with this software; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  02110-1301 USA
*/

#include <stdio.h>
#if SAPP_FUNC
#include <shadowapp.h>
#endif
#include "game.h"
#include "callbacks.h"

extern int terminate_game;

/**
  Exit callback for libshadow. Pause the game
  @param errcode the error code
  @return 0 on success
*/
int
exit_callback(int errcode)
{
    FILE *han;


    if (game_over)
    {
        remove("/tmp/.maemoblocks-save");
        return 0;
    }

    // Save state
    han = fopen("/tmp/.maemoblocks-save", "wb");
    if (han)
    {
        fwrite(matrix, sizeof(int), MAX_X * MAX_Y, han);
        fwrite(&cur_x, sizeof(int), 1, han);
        fwrite(&cur_y, sizeof(int), 1, han);
        fwrite(&cur_block, sizeof(int), 1, han);
        fwrite(&cur_frame, sizeof(int), 1, han);
        fwrite(&current_score, sizeof(int), 1, han);
        fwrite(&current_level, sizeof(int), 1, han);
        fwrite(&current_lines, sizeof(int), 1, han);
        fwrite(&next_block, sizeof(int), 1, han);
        fwrite(&next_frame, sizeof(int), 1, han);
        // fwrite(&show_next_block, sizeof(int), 1, han);
        fclose(han);
    }

    terminate_game = 1;

    return 0;
}

/**
  Quit callback for libshadow. Close the game
  @param errcode the error code
  @return 0 on success
*/
int
quit_callback(int errcode)
{
    remove("/tmp/.maemoblocks-save");

    terminate_game = 1;

    return 0;
}

/**
  Flush callback for libshadow.
  @param errcode the error code
  @return 0 on success
*/
int
flush_callback(int errcode)
{
    remove("/tmp/.maemoblocks-save");

    return 0;
}
