
#include "tp-helpers.h"

static void
print_parameter (gpointer key, gpointer value, gpointer user_data)
{
  const gchar *name = key;
  TpConnMgrProtParam *param = value;

  g_print ("   - parameter %s: ", name);

  if (param->flags & TP_CONNMGR_PROT_PARAM_FLAG_REQUIRED)
    g_print ("required; ");

  if (param->flags & TP_CONNMGR_PROT_PARAM_FLAG_REGISTER)
    g_print ("register; ");

  if (param->flags & TP_CONNMGR_PROT_PARAM_FLAG_HAS_DEFAULT)
    g_print ("default = %s; ", param->default_value);

  g_print ("\n");
}

static void
print_protocol (gpointer key, gpointer value, gpointer user_data)
{
  const gchar *name = key;
  GHashTable *parameters = value;

  g_print (" - protocol: %s\n", name);
  g_hash_table_foreach (parameters, print_parameter, NULL);
}

int
main (int argc, char *argv[])
{
  TpConnMgrInfo *info;

  if (argc != 2)
    return 1;

  info = tp_connmgr_get_info (argv[1]);

  if (info == NULL)
    return 1;

  g_print ("name: %s\n", info->name);
  g_print ("bus name: %s\n", info->bus_name);
  g_hash_table_foreach (info->protocols, print_protocol, NULL);

  tp_connmgr_info_free (info);
  return 0;
}

