/* LibComApp
 *
 * Copyright (C) 2007 Nokia Corporation. 
 *
 * Contact: Ahmad Qureshi <Ahmad.Qureshi@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */


#include "comapp_i18n.h"
#include <glib.h>
#include <hildon/hildon-help.h>
#include <gtk/gtk.h>
#include <hildon/hildon-defines.h>
#include <hildon/hildon-banner.h>
#include "comapp_details.h"
#include "comapp_common.h"

#define MSG_NOT_AVAILABE "note_ib_not_available"




GtkWidget *
comapp_details_new(ComappDetailsData * ddata)
{
    gint item_num = 0, line_num = 1;
    GtkTable *details_table = NULL;
    GtkLabel *temp_label = NULL;
    GSList *details = NULL;
    ComappDetailItem *detail_item = NULL;
    gchar *tmp = NULL;
    GtkTreeIter iter;
    gboolean iter_valid = TRUE;
    GtkWidget *details_dialog = NULL;

    g_assert(ddata);
    g_assert(ddata->details_data);
    details = ddata->details_data;

    item_num = g_slist_length(details);
    if (item_num)
    {
        details_table = GTK_TABLE(gtk_table_new(item_num + 1, 2, FALSE));
        gtk_widget_show(GTK_WIDGET(details_table));
        gtk_table_set_col_spacings(GTK_TABLE(details_table),
                                   HILDON_MARGIN_DEFAULT);
        gtk_container_set_border_width(GTK_CONTAINER(details_table),
                                       HILDON_MARGIN_DEFAULT);

        temp_label = GTK_LABEL(gtk_label_new(""));
        gtk_widget_show(GTK_WIDGET(temp_label));
        gtk_table_attach(GTK_TABLE(details_table), GTK_WIDGET(temp_label), 0,
                         1, 0, 1, (GtkAttachOptions) (GTK_FILL),
                         (GtkAttachOptions) (GTK_EXPAND), 0, 0);
        gtk_misc_set_alignment(GTK_MISC(temp_label), 0, 0.5);

        temp_label = GTK_LABEL(gtk_label_new(""));
        gtk_widget_show(GTK_WIDGET(temp_label));
        gtk_table_attach(GTK_TABLE(details_table), GTK_WIDGET(temp_label), 0,
                         1, 5, 6, (GtkAttachOptions) (GTK_FILL),
                         (GtkAttachOptions) (GTK_EXPAND), 0, 0);
        gtk_misc_set_alignment(GTK_MISC(temp_label), 0, 0.5);

        while (details)
        {
            detail_item = (ComappDetailItem *) details->data;

            // adding name
            tmp = g_strdup_printf("%s ", detail_item->name);
            temp_label = GTK_LABEL(gtk_label_new(tmp));
            g_free(tmp);
            gtk_widget_show(GTK_WIDGET(temp_label));
            gtk_table_attach(GTK_TABLE(details_table), GTK_WIDGET(temp_label),
                             0, 1, line_num, line_num + 1,
                             (GtkAttachOptions) (GTK_FILL),
                             (GtkAttachOptions) (GTK_FILL), 0, 0);
            gtk_misc_set_alignment(GTK_MISC(temp_label), 1.0, 0.0);

            temp_label = GTK_LABEL(gtk_label_new(detail_item->content));
            gtk_widget_show(GTK_WIDGET(temp_label));
            gtk_table_attach(GTK_TABLE(details_table), GTK_WIDGET(temp_label),
                             1, 2, line_num, line_num + 1,
                             (GtkAttachOptions) (GTK_FILL),
                             (GtkAttachOptions) (GTK_FILL), 0, 0);
            gtk_label_set_line_wrap(GTK_LABEL(temp_label), TRUE);
            gtk_misc_set_alignment(GTK_MISC(temp_label), 0, 0.0);

            line_num++;
            details = g_slist_next(details);
        }
    }
    else
    {                           // empty list
    }

    if (!ddata->fs_model)
    {
        ddata->fs_model = comapp_common_new_fs_model(ddata->parent);
    }
    else
    {
        if (ddata->parent)
        {
            comapp_common_fs_model_set_ref_widget(ddata->fs_model,
                                                  ddata->parent);
        }
    }
    g_assert(ddata->uri);
    /* load the uri and set the GtkTreeIter */
    if (!hildon_file_system_model_load_uri
        (ddata->fs_model, ddata->uri, &iter))
    {
        hildon_banner_show_information(GTK_WIDGET(ddata->parent), NULL,
                                       _(MSG_NOT_AVAILABE));
        iter_valid = FALSE;
    }

    g_assert(ddata->parent);
    g_assert(ddata->fs_model);
    /* create file details dialog */
    details_dialog = hildon_file_details_dialog_new_with_model
        (GTK_WINDOW(ddata->parent), ddata->fs_model);


    gtk_window_set_modal(GTK_WINDOW(details_dialog), TRUE);
    if (iter_valid)
    {
        hildon_file_details_dialog_set_file_iter
            (HILDON_FILE_DETAILS_DIALOG(details_dialog), &iter);
    }

    if (ddata->window_title)
    {
        g_object_set(G_OBJECT(details_dialog),
                     "title", ddata->window_title, NULL);
    }

    if (ddata->label_title)
    {
        g_object_set(G_OBJECT(details_dialog),
                     "additional-tab-label", ddata->label_title, NULL);
    }

    g_object_set(G_OBJECT(details_dialog),
                 "show_tabs", TRUE, "additional-tab", details_table, NULL);

    if (ddata->help_title && ddata->osso)
    {
        hildon_help_dialog_help_enable(GTK_DIALOG(details_dialog),
                                       ddata->help_title, ddata->osso);
    }

    return details_dialog;
}
