/*
 * rtpgstcodecs.h - Headers for RTP gstreamer codec setting
 *
 * Farsight RTP/AVP/SAVP/AVPF Module
 * Copyright (C) 2005,2006 Collabora Ltd.
 * Copyright (C) 2005,2006 Nokia Corporation
 *   @author Rob Taylor <rob.taylor@collabora.co.uk>
 *   @author Philippe Kalaf <philippe.kalaf@collabora.co.uk>
 * Copyright (C) 2005 INdT 
 *   @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __FARSIGHT_RTP_GST_CODECS_H__
#define __FARSIGHT_RTP_GST_CODECS_H__

#include <gst/gst.h>

#include "farsight-stream.h"
#include "farsight-codec.h"

#define DIR_SEND 0
#define DIR_RECV 1

G_BEGIN_DECLS

typedef struct _CodecBlueprint CodecBlueprint;

struct _CodecBlueprint
{
  FarsightCodec *codec;
  GstCaps *media_caps;
  GstCaps *rtp_caps;
  GList *send_pipeline_factory;
  GList *receive_pipeline_factory;
  gboolean has_sink;
  gboolean has_src;

  gint send_has_unique;
  gint receive_has_unique;
  GstElement *send_unique_bin;
  GstElement *receive_unique_bin;
};

typedef struct _CodecAssociation
{
  CodecBlueprint *codec_blueprint;
  FarsightCodec *codec;
} CodecAssociation;


gboolean load_codecs (FarsightMediaType media_type);
void unload_codecs (FarsightMediaType media_type);
void sort_codecs (GList **list_codecs,
    const GArray *codec_preference);
GHashTable *create_pt_caps_hashtable(GHashTable *codecs);

void codec_blueprint_destroy (gpointer data);

GstElement *create_codec_bin (GHashTable *codec_associations,
    gint codec_id, gboolean dir, const GList *remote_codecs);

CodecAssociation *lookup_codec_by_pt (GHashTable *codec_associations, gint pt);

GHashTable *create_local_codec_associations (FarsightMediaType media_type,
    GList *codec_prefs, GHashTable *current_codec_associations,
    GList **local_codecs_list);

GstCaps *farsight_codec_to_gst_caps (FarsightCodec *codec);

GstElement *get_unique_bin (FarsightMediaType media_type,
    FarsightStreamDirection direction, gint unique_id);

GList *validate_codecs_configuration (FarsightMediaType media_type, GList *codecs);

GHashTable *negotiate_codecs (const GList *remote_codecs,
    GHashTable *negotiated_codec_associations,
    GHashTable *local_codec_associations, GList *local_codecs,
    GList **negotiated_codecs_out);

G_END_DECLS

#endif
