/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Leonid Zolotarev <leonid.zolotarev@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#include "gwebpassman.h"

static void
g_web_password_manager_base_init (gpointer g_class)
{
	static gboolean initialized = FALSE;

	if (!initialized) {
		/* create interface signals here. */
		initialized = TRUE;
	}
}

GType
g_web_password_manager_get_type (void)
{
    static GType type = 0;
    if (type == 0) {
        static const GTypeInfo info = {
            sizeof (GWebPasswordManagerIface),
            g_web_password_manager_base_init,   /* base_init */
            NULL,   /* base_finalize */
            NULL,   /* class_init */
            NULL,   /* class_finalize */
            NULL,   /* class_data */
            0,
            0,      /* n_preallocs */
            NULL    /* instance_init */
        };
        type = g_type_register_static (G_TYPE_INTERFACE, "GWebPasswordManager", &info, 0);
    }
    return type;
}

GType      g_web_password_manager_get_type         (void);

GWebStatus
g_web_password_manager_get_login_username (GWebPasswordManager *self, gchar** username)
{
        return G_WEB_PASSWORD_MANAGER_GET_CLASS (self)->get_login_username (self, username);
}

GWebStatus
g_web_password_manager_get_login_password(GWebPasswordManager*self, gchar** password)
{
        return G_WEB_PASSWORD_MANAGER_GET_CLASS (self)->get_login_password (self, password);
}

GObject* 
g_web_password_manager_login_get_personal_data(GWebPasswordManager *self)
{
        return G_WEB_PASSWORD_MANAGER_GET_CLASS (self)->login_get_personal_data (self);
}
