
__all__ = ['register', 'unregister', 'handler', 'get_connection', 'bus_request_name']

import time
import sys

try:
    import dbus
    import dbus.glib
except ImportError, e:
    print e
    sys.exit(77)

def get_interface():
    bus = dbus.SystemBus()
    obj = bus.get_object('com.nokia.ObexServer', '/com/nokia/ObexServer')
    interface = dbus.Interface(obj, 'com.nokia.ObexServer')
    return interface

def get_connection():
    bus = dbus.SystemBus()
    c   = bus.get_connection()
    return c

def bus_request_name(connection, name):
    dbus.dbus_bindings.bus_request_name(connection, name)

def get_xfer_interface(path):
    bus = dbus.SystemBus()
    obj = bus.get_object('com.nokia.ObexServer', path)
    interface = dbus.Interface(obj, 'com.nokia.ObexServer.Transfer')
    return interface

def register(path):
    i = get_interface()
    i.RegisterHandler(path)
    time.sleep(1)

def unregister(path):
    i = get_interface()
    i.UnregisterHandler(path)

class handler:
    def __init__(self, connection, dbus_path, fname):
        self.fname     = fname
        self.dbus_path = dbus_path
        connection.register_object_path(dbus_path, self._f, self._authorize)
        register(self.dbus_path)

    def _f(self, connection, message):
        print 'f'

    def authorize(self, name):
        if name == 'xyz':
            return False
        else:
            return True

    def _authorize(self, connection, message):
        assert message.is_method_call('com.nokia.ObexServer.Handler', 'Authorize')
        args = message.get_args_list()
        self.objpath = args[0]
        name = args[2]

        if self.authorize(name):
            reply = dbus.dbus_bindings.MethodReturn(message)
            i = reply.get_iter(append=True)
            i.append(self.fname)
        else:
            reply = dbus.dbus_bindings.Error(message, 'a.bc', 'def')

        i = get_xfer_interface(self.objpath)
        i.connect_to_signal('Started', self.Started)
        i.connect_to_signal('Completed', self.Completed)
        i.connect_to_signal('Progress', self.Progress)

        connection.send(reply)

    def Started(self, success):
        pass

    def Completed(self, success):
        pass

    def Progress(self, transfered, size):
        pass

    def cancel(self):
        i = get_xfer_interface(self.objpath)
        try:
            i.Cancel()
        except Exception, e:
            print e
