/**
  @file client.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2006 Nokia Corporation. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _CLIENT_H_
#define _CLIENT_H_

#include <stdint.h>
#include <time.h>
#include <glib.h>
#include <bluetooth/bluetooth.h>
#include <bluetooth/rfcomm.h>

#include "server.h"

typedef struct {
    uint8_t         cmd;

    char           *name;
    char           *type;
    char           *dscr;
    time_t          time;

    size_t          length;
    size_t          counter;

    gboolean        success;

    gboolean        is_delete;

    unsigned char  *buf;               
    size_t          data_len;
    size_t          buf_size;

    char           *filename;
    int             fd;

    uint32_t        count;
} ObjectTransfer;

typedef struct client_connection ClientConnection;

typedef char * (*client_auth_cb_t) (ClientConnection *client,
                                    ObjectTransfer   *xfer,
                                    gpointer          user_data);

typedef gboolean (*client_progr_cb_t) (ClientConnection *client,
                                       ObjectTransfer   *xfer,
                                       gpointer          user_data);

typedef void (*client_xfer_cb_t) (ClientConnection *client,
                                  ObjectTransfer   *xfer,
                                  gboolean          started,
                                  gboolean          success,
                                  gpointer          user_data);

typedef void (*client_dc_cb_t) (ClientConnection *client, gpointer data);

char *client_authorize(ClientConnection *client);

void client_transfer_start(ClientConnection *client);

void client_transfer_complete(ClientConnection *client);

void client_transfer_set_success(ClientConnection *client, gboolean success);

gboolean client_progress(ClientConnection *client);

void client_add_disconnect_callback(ClientConnection *client,
                                    client_dc_cb_t cb, gpointer user_data);

void client_remove_disconnect_callback(ClientConnection *client,
                                       client_dc_cb_t cb, gpointer user_data);

void client_set_tx_max(ClientConnection *client, uint16_t size);

ObjectTransfer *client_get_transfer(ClientConnection *client, uint8_t cmd);

const char *client_get_bt_address(ClientConnection *client);

gboolean client_allow_target(ClientConnection *client, const unsigned char *target, unsigned int length);

ClientConnection *client_new(ServerContext *server, int fd, struct sockaddr_rc *addr, const char *root);

gboolean client_close(ClientConnection *client);

#endif /* _CLIENT_H_ */
