/**
  @file obc-main.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _OBC_MAIN_H_
#define _OBC_MAIN_H_

#include <time.h>
#include <glib.h>
#include <gw-obex.h>

#include "main.h"

typedef struct {
    GwObex   *obex;

    time_t    start;

    char     *object;

    gboolean  use_btcond;
    gboolean  user_dev;
    char     *user_bda;
    char     *resolved_name;

    int       channel;

    gboolean  try_remote_name;
    gboolean  show_progress;
    gboolean  xfer_complete;

    char     *target;
    int       target_len;

    gboolean  use_auth;
    gboolean  use_encr;
    char     *set_role;

    gboolean  async;
    gint      mtu;

    char      cwd[256];
    GSList   *fl_cache;

    GSList   *dev_cache;

    char     *rfcomm_dev;
    int       sk;
} ObcContext;

#include "completion.h"

typedef gboolean (*cmd_func)(ObcContext *ctx, gint argc, gchar *argv[], gint *err);
typedef void (*help_func)(ObcContext *ctx, const char *name);

typedef struct {
    const gchar *name;
    cmd_func     func;
    Completion   completion;
    gboolean     dc_allow;
    help_func    long_help;
    const gchar *help;
} Command;

extern Command cmd_table[];

extern volatile gboolean do_abort;

void obc_show_progress(ObcContext *ctx, gboolean show);

void progress_cb(GwObex *obex, gint cmd, gint current, gint target,
                 ObcContext *ctx);

void obc_init(ObcCfg *cfg);

#endif /* _OBC_MAIN_H_ */
